<?php

namespace Tests\Unit;

use Tests\TestCase;
use Base\Validation\FormValidator;
use PHPUnit\Framework\Attributes\DataProvider;

class FormValidatorTest extends TestCase
{
    public static function formParameters (): array
    {
        return [
            "Failed Form Parameter" => ["tbl_sample", "Sample", "add",
                [
                    "email" => "abc@som",
                    "size" => "not a number",
                    "first_name" => "sample name",
                    "tags" => ["sample", "Hanokle"],
                    "family" => [
                        [
                            "first_name" => "Something",
                            "last_name" => "NowayHosey"
                        ]
                    ],
                    "guardian" => ["first_name" => "Sinething" , "last_name" => "Something", "contact" => "0912312"],
                ]
            ]
        ];
    }

    #[DataProvider('formParameters')]
    public function testFormParameter(string $table, string $form, string $mode, array $data = []) {
        $formValidator = new FormValidator($table, $form, $mode, $data);
        $formValidator->validate();
        $formValidator->getValidated();
    }
}
