<?php

use App\Http\Controllers\RequestBuilder\BladeController;
use Accounting\billing\Billings;
use Illuminate\Support\Facades\Route;
use Accounting\reports\TransactionReports;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/request-builder', [BladeController::class, 'requestBuilder']);
Route::post('/save-request', [BladeController::class, 'saveRequest']);
Route::post('/update-request', [BladeController::class, 'updateReqsFields']);
Route::get('/view-billing/{code}', [Billings::class, 'previewBilling']);
Route::get('/view-accounts-receivable', [Billings::class, 'previewAccountsReceivable']);

Route::get('/billing-statement/{billingNumber}', [TransactionReports::class, 'billingView']);
Route::get('/billing-voucher/{billingNumber}', [TransactionReports::class, 'billingVoucherView']);
Route::get('/voucher/{voucherNo}', [TransactionReports::class, 'vouchers']);

Route::get('/balanceSheet', function (){
    $pdf_parse = PDF::loadView('templates/reports/balanceSheet',[]);
    $pdf_parse->setPaper('a4', 'portrait');
    return $pdf_parse->stream();
});
Route::get('/incomeStatement', function (){
    $pdf_parse = PDF::loadView('templates/reports/incomeStatement',[]);
    $pdf_parse->setPaper('a4', 'portrait');
    return $pdf_parse->stream();
});
Route::get('/trialBalance', function (){
    $pdf_parse = PDF::loadView('templates/reports/trialBalance',[]);
    $pdf_parse->setPaper('a4', 'portrait');
    return $pdf_parse->stream();
});
Route::get('/billingStatement', function (){
    $pdf_parse = PDF::loadView('templates/reports/billingStatement',[]);
    $pdf_parse->setPaper('a4', 'portrait');
    return $pdf_parse->stream();
});
Route::get('/customerSoa', function (){
    $pdf_parse = PDF::loadView('templates/reports/customerSoa',[]);
    $pdf_parse->setPaper('a4', 'portrait');
    return $pdf_parse->stream();
});
Route::get('/accountsReceivable', function (){
    $pdf_parse = PDF::loadView('templates/reports/accountsReceivable',[]);
    $pdf_parse->setPaper('a4', 'landscape');
    return $pdf_parse->stream();
});
Route::get('/budgetVsActualMonthly', function (){
    $pdf_parse = PDF::loadView('templates/reports/budgetVsActual_Monthly',[]);
    $pdf_parse->setPaper('a4', 'portrait');
    return $pdf_parse->stream();
});
Route::get('/budgetVsActualPeriodical', function (){
    $pdf_parse = PDF::loadView('templates/reports/budgetVsActual_Periodical',[]);
    $pdf_parse->setPaper('a4', 'landscape');
    return $pdf_parse->stream();
});
Route::post('/api-login', [TransactionReports::class, 'apiLogin']);
