<style>
    #billingStatementContent {
        margin-top: 5px;
        border-collapse: collapse;
        border: 1pt solid #1a202c
    }
    #billingStatementContent th {
        padding: 6px;
        border: 1px solid #1a202c;
        text-align: center;
    }
    #billingStatementContent td {
        padding: 3px;
        border: 1px solid #1a202c;
        text-align: center;
        height: 16px;
        font-size: 9pt;
    }
    #billingStatementTotal {
        border-collapse: collapse;
        border: 1px solid #1a202c;
    }
    #billingStatementTotal td {
        padding: 2px;
        height: 16px;
        font-size: 7pt;
    }
    #billingStatementConditions {
        margin-bottom: -128px;
        margin-left: 24px;
        width: 350px;
        border-collapse: collapse;
        /*background: #f1f1f1;*/
    }
    #billingStatementConditions td{
        padding: 2px 4px;
        height: 16px;
        font-size: 7pt;
        font-family: "Courier New", monospace !important;
    }
    #billingStatementHeader {
        margin-top: 15px;
        border-collapse: collapse;
    }
    #billingStatementHeader th, #billingStatementHeader td {
        padding: 2px;
    }

    #billingStatementHeader td {
        font-size: 9pt;
    }
</style>

@extends('templates/report')

@section('reportTitle')
    <title style="font-weight: bold;">Journal Voucher</title>
@endsection

@section('reportHeader')
    <h2 class="tx-center">
        JOURNAL VOUCHER
    </h2>
    <h2 style="text-align: right; margin-top: -24px; color: red; font-size: 1.3em; font-family: 'Courier New', monospace !important;">
        No: {{$voucherNo}}
    </h2>
    <table id="billingStatementHeader">
        <tbody>
        <tr>
            <th style="width: 12%">Particulars : </th>
            <td> {{ $particulars }}</td>
            <th style="width: 2%"></th>
            <th style="width: 6%">Date: </th>
            <td class="tx-right" style="width: 12%">{{$transDate}}</td>
        </tr>
        </tbody>
    </table>
@endsection

@section('content')
    <table id="billingStatementContent">
        <thead>
        <tr>
            <th style="width: 60%;text-align: left;padding-left: 10px;">PARTICULARS</th>
            <th>DEBIT</th>
            <th>CREDIT</th>
        </tr>
        </thead>
        <tbody>
        @if(isset($entries))
            @foreach($entries as $entry)
                <tr>
                    <td style="text-align: left;padding-left: 10px;border:none;padding-top: 2px;">
                        @if($entry['normalBalance'] === 'Cr')
                            <p style="padding-left: 10px;">
                                    <span style="font-weight: bold;font-family: 'Courier New', monospace !important;">
                                        {{$entry['account']}}
                                    </span><br>
                                <span style="padding-left: 10px;font-family: 'Courier New', monospace !important;">{{$entry['details']}}</span>
                            </p>

                        @else
                            <span style="font-weight: bold;font-family: 'Courier New', monospace !important;">
                                    {{$entry['account']}}
                                </span><br>
                            <span style="padding-left: 10px;font-family: 'Courier New', monospace !important;">{{$entry['details']}}</span>
                        @endif

                    </td>
                    <td style="text-align: right;padding-right: 10px;vertical-align: top;border:none;">
                        <span style="font-family: 'Courier New', monospace !important;">{{$entry['debit']}}</span>
                    </td>
                    <td style="text-align: right;padding-right: 10px;vertical-align: top;border:none;">
                        <span style="font-family: 'Courier New', monospace !important;">{{$entry['credit']}}</span>
                    </td>
                </tr>
            @endforeach
        @endif
        </tbody>
    </table>

    <table style="margin-top: 20px;">
        <thead>
        <tr>
            <th style="text-align: center;"></th>
            <th style="text-align: center;"></th>
            <th style="text-align: center;"></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td style="text-align: center;align-items: center !important;align-content: center !important;">
                <strong></strong>
                <br>
                <div style="margin: 0 20px 0 20px !important;width: 180px;" class="border-bottom"></div>
                <span>Prepared By</span>
            </td>
            <td style="text-align: center;">
                <strong></strong>
                <br>
                <div style="margin: 0 20px 0 20px !important;width: 180px;" class="border-bottom"></div>
                <span>Checked By</span>
            </td>
            <td style="text-align: center;">
                <strong></strong>
                <br>
                <div style="margin: 0 20px 0 20px !important;width: 180px;" class="border-bottom"></div>
                <span>Approved By</span>
            </td>
        </tr>
        </tbody>
    </table>

    <table style="display: none;">
        <tbody>
        <tr>
            <th style="width: 60%"></th>
            <td style="width: 16px; vertical-align: bottom; padding-bottom: 16px">By: </td>
            <td class="tx-center" style="width: 30%; padding-top: 32px">
                <strong>TAKAAKI OZEKI / NAOYA OHE</strong>
                <br>
                <div class="border-bottom"></div>
                <span>Authorized Signature</span>
            </td>
        </tr>
        </tbody>
    </table>


@endsection
