<style>
    #billingStatementContent {
        margin-top: 16px;
        border-collapse: collapse;
        border: 1pt solid #1a202c
    }
    #billingStatementContent th {
        padding: 6px;
        border: 1px solid #1a202c;
        text-align: center;
    }
    #billingStatementContent td {
        padding: 2px;
        border: 1px solid #1a202c;
        text-align: center;
        height: 16px;
        font-size: 7pt;
    }
    #billingStatementTotal {
        border-collapse: collapse;
        border: 1px solid #1a202c;
    }
    #billingStatementTotal td {
        padding: 2px;
        height: 16px;
        font-size: 7pt;
    }
    #billingStatementConditions {
        margin-bottom: -128px;
        margin-left: 24px;
        width: 350px;
        border-collapse: collapse;
        /*background: #f1f1f1;*/
    }
    #billingStatementConditions td{
        padding: 2px 4px;
        height: 16px;
        font-size: 7pt;
    }
    #billingStatementHeader {
        margin-top: 8px;
        border-collapse: collapse;
    }
    #billingStatementHeader th, #billingStatementHeader td {
        padding: 2px;
    }
</style>

@extends('templates/report')

@section('reportTitle')
    <title style="font-weight: bold;">Billing Statement Sample</title>
@endsection

@section('reportHeader')
    <h2 class="tx-center">
        BILLING STATEMENT
    </h2>
    <h2 style="text-align: right; margin-top: -24px; color: red; padding-right: 16px">
        No: {{$billing_no}}
    </h2>
    <table id="billingStatementHeader" style="margin-top: 20px;">
        <tbody>
            <tr>
                <th style="width: 15%">Client : </th>
                <td class="border-bottom"> {{ $clientName }} </td>
                <th style="width: 2%"></th>
                <th style="width: 7%">Date: </th>
                <td class="border-bottom tx-center" style="width: 15%">{{\Carbon\Carbon::parse($billing_date)->format('d-M-Y')}}</td>
            </tr>
            <tr>
                <th>TIN : </th>
                <td class="border-bottom"> {{ $clientTIN }} </td>
                <th></th>
                <th></th>
                <td></td>
            </tr>
            <tr>
                <th>Address : </th>
                <td class="border-bottom"></td>
                <th></th>
                <th>Terms: </th>
                <td class="border-bottom tx-center"> {{$terms}} {{$unit}}</td>
            </tr>
            <tr>
                <th>Business Style : </th>
                <td class="border-bottom"> {{ ucwords($clientBusType) }}</td>
                <th></th>
                <th></th>
                <td></td>
            </tr>
        </tbody>
    </table>
@endsection

@section('content')
    <table id="billingStatementContent">
        <thead>
            <tr>
                <th colspan="5">DESCRIPTION</th>
                <th>AMOUNT</th>
            </tr>
            <tr>
                <th style="width: 4%">QTY</th>
                <th style="width: 13%">VOF No.</th>
                <th style="width: 10%">SO No.</th>
                <th>Model</th>
                <th style="width: 10%">Measurement <br> (CBM)</th>
                <th style="width: 20%"></th>
            </tr>
        </thead>
        <tbody>
        @foreach($transDetails as $transDetail)
            <tr>
                <td class="text-xl-center">{{$transDetail->quantity}}</td>
                <td class="text-xl-center">{{$transDetail->vof_no}}</td>
                <td class="text-xl-center">{{$transDetail->so_no}}</td>
                <td class="tx-left">{{$transDetail->particulars}}</td>
                <td class="text-xl-center">{{$transDetail->measurement}}</td>
                <td class="tx-right-indented">{{number_format($transDetail->amount, 2,'.',',')}}</td>
            </tr>
        @endforeach
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        </tbody>
    </table>

    <table id="billingStatementConditions">
        <tr>
            <td style="width: 30%">Condition
                <span style="float: right">:</span>
            </td>
            <td>{{$billingDetails['condition']}}</td>
        </tr>
        <tr>
            <td>Port of Origin
                <span style="float: right">:</span>
            </td>
            <td>{{$billingDetails['portOrigin']}}</td>
        </tr>
        <tr>
            <td>Port of Destination
                <span style="float: right">:</span>
            </td>
            <td>{{$billingDetails['portDestination']}}</td>
        </tr>
        <tr>
            <td>Vessel
                <span style="float: right">:</span>
            </td>
            <td>{{$billingDetails['vessel']}}</td>
        </tr>
        <tr>
            <td>ATD
                <span style="float: right">:</span>
            </td>
            <td>{{\Carbon\Carbon::parse($billingDetails['atd'])->format('M-d-Y h:i A')}}</td>
        </tr>
        <tr>
            <td>ATA
                <span style="float: right">:</span>
            </td>
            <td>{{\Carbon\Carbon::parse($billingDetails['ata'])->format('M-d-Y h:i A')}}</td>
        </tr>
    </table>

    <table id="billingStatementTotal">
        <tr>
            <td colspan="3"></td>
            <td style="width: 20%;">Total :</td>
            <td class="tx-right-indented" style="width: 20%">{{number_format($billingDetails['amount'],2,'.',',')}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>Bunker Adjusted Facic</td>
            <td class="tx-right-indented">{{$billingDetails['BAF']}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>Rate adjusted 9.99%</td>
            <td class="tx-right-indented">{{$billingDetails['rateAdjusted']}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>Total Freight Charge :</td>
            <td class="tx-right-indented">{{$billingDetails['freightCharge']}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>12% Value Added Tax :</td>
            <td class="tx-right-indented">{{$billingDetails['VAT']}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>Less: EW 2%</td>
            <td class="tx-right-indented">({{$billingDetails['EWT']}})</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <th>TOTAL AMOUNT DUE:</th>
            <th class="tx-right-indented">{{$billingDetails['amountDue']}}</th>
        </tr>
    </table>

    <table>
        <tbody>
        <tr>
            <th style="width: 60%"></th>
            <td style="width: 16px; vertical-align: bottom; padding-bottom: 16px">By: </td>
            <td class="tx-center" style="width: 30%; padding-top: 32px">
                <strong>TAKAAKI OZEKI / NAOYA OHE</strong>
                <br>
                <div class="border-bottom"></div>
                <span>Authorized Signature</span>
            </td>
        </tr>
        </tbody>
    </table>

    <footer class="tx-center">
        <p>
            THIS DOCUMENT IS NOT VALID FOR CLAIMING INPUT TAX
        </p>
        <P>"THIS BILLING STATEMENT SHALL BE VALID FOR FIVE(5) YEARS FROM THE DATE OF ATP"</P>
    </footer>
@endsection
