<style>
    #billingStatementContent {
        margin-top: 16px;
        border-collapse: collapse;
        border: 1pt solid #1a202c
    }
    #billingStatementContent th {
        padding: 6px;
        border: 1px solid #1a202c;
        text-align: center;
    }
    #billingStatementContent td {
        padding: 2px;
        border: 1px solid #1a202c;
        text-align: center;
        height: 16px;
        font-size: 8.5pt;
    }
    #billingStatementTotal {
        border-collapse: collapse;
        border: 1px solid #1a202c;
    }
    #billingStatementTotal td {
        padding: 2px;
        height: 16px;
        font-size: 8.5pt;
    }
    #billingStatementConditions {
        margin-bottom: -128px;
        margin-left: 24px;
        width: 350px;
        border-collapse: collapse;
        /*background: #f1f1f1;*/
    }
    #billingStatementConditions td{
        padding: 2px 4px;
        height: 16px;
        font-size: 7pt;
    }
    #billingStatementHeader {
        margin-top: 8px;
        border-collapse: collapse;
    }
    #billingStatementHeader th, #billingStatementHeader td {
        padding: 2px;
    }

    .width-8 {
        width: 8%;
    }

    .width-10 {
        width: 10%;
    }

    .width-12 {
        width: 12%;
    }

    .width-40 {
        width: 40%;
    }

    .width-20 {
        width: 20%;
    }

    .text-end {
        text-align: right !important;
        padding-right: 10px !important;
    }

    .text-start {
        text-align: left !important;
        padding-left: 10px !important;
    }

    .text-center {
        text-align: center !important;
    }
</style>

@extends('templates/report')

@section('reportTitle')
    <title style="font-weight: bold;">Billing Statement</title>
@endsection

@section('reportHeader')
    <h2 class="tx-center">
        BILLING STATEMENT
    </h2>
    <h2 style="text-align: right; margin-top: -24px; color: red; padding-right: 16px">
        No: {{$billing_no}}
    </h2>
    <table id="billingStatementHeader">
        <tbody>
            <tr>
                <th style="width: 15%">Client : </th>
                <td class="border-bottom"> {{ $customer->name }}</td>
                <th style="width: 2%"></th>
                <th style="width: 7%">Date: </th>
                <td class="border-bottom tx-center" style="width: 15%">{{$billingDateDetails}}</td>
            </tr>
            <tr>
                <th>TIN : </th>
                <td class="border-bottom">{{ $customer->billingDetails['tin'] }}</td>
                <th></th>
                <th></th>
                <td></td>
            </tr>
            <tr>
                <th>Address : </th>
                <td class="border-bottom">{{ $customer->billingDetails['address'] }}</td>
                <th></th>
                <th>Terms: </th>
                <td class="border-bottom tx-center"> {{$termsDetails}}</td>
            </tr>
            <tr>
                <th>Business Style : </th>
                <td class="border-bottom">{{ $customer->billingDetails['businessStyle'] }}</td>
                <th></th>
                <th></th>
                <td></td>
            </tr>
        </tbody>
    </table>
@endsection

@section('content')
    <table id="billingStatementContent">
        <thead>
            <tr>
                @foreach($itemHeaders as $headers)
                    <th class="{{$headers['class']}}">{{ $headers['name'] }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
        @foreach($items as $item)
            <tr>
                @foreach($itemColums as $itemColum)
                    @foreach($item as $key => $value)
                        @if($itemColum['code'] === $key)
                            <td class="{{$itemColum['class']}}">{{$itemColum['type'] === 'currency' ? number_format($value, 2,'.',',') : $value}}</td>
                        @endif
                    @endforeach

                @endforeach
            </tr>
        @endforeach
        @while($rowCount > 0)
            <tr>
                    <?php $columns = $columnCount; ?>
                @while($columns > 0)
                    <td></td>
                    <?php $columns = $columns - 1; ?>
                @endwhile
            </tr>
            <?php $rowCount = $rowCount - 1; ?>
        @endwhile
        </tbody>
    </table>

    <table id="billingStatementTotal">
        <tr>
            <td colspan="3"></td>
            <td style="width: 20%;">Total :</td>
            <td class="tx-right-indented-10" style="width: 20%">{{$amountDetails}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>12% Value Added Tax :</td>
            <td class="tx-right-indented-10">{{$vatDetails}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td>Less: EW 2%</td>
            <td class="tx-right-indented-10">{{$ewtDetails > 0 ? '('.$ewtDetails.')' : $ewtDetails}}</td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <th>TOTAL AMOUNT DUE:</th>
            <th class="tx-right-indented-10" style="font-size: 1.1em;">{{$amountDue}}</th>
        </tr>
    </table>

    <table>
        <tbody>
        <tr>
            <th style="width: 60%"></th>
            <td style="width: 16px; vertical-align: bottom; padding-bottom: 16px">By: </td>
            <td class="tx-center" style="width: 30%; padding-top: 32px">
                <strong>TAKAAKI OZEKI / NAOYA OHE</strong>
                <br>
                <div class="border-bottom"></div>
                <span>Authorized Signature</span>
            </td>
        </tr>
        </tbody>
    </table>

    <footer class="tx-center">
        <p>
            THIS DOCUMENT IS NOT VALID FOR CLAIMING INPUT TAX
        </p>
        <P>"THIS BILLING STATEMENT SHALL BE VALID FOR FIVE(5) YEARS FROM THE DATE OF ATP"</P>
    </footer>
@endsection
