<style>
#accountsReceivable {
    margin-top: 16px;
    border-collapse: collapse;
    border: 1pt solid #1a202c;
}
#accountsReceivable td {
    height: 16px;
    border-left: 1px solid #1a202c;
    border-right: 1px solid #1a202c;
    text-align: center;
    padding: 2px;
    font-size: 7pt;
}
#accountsReceivable th {
    border: 1pt solid #1a202c;
    text-align: center;
    font-weight: normal;
    padding: 2px;
}
</style>


@extends('templates/report')

@section('reportTitle')
    <title style="font-weight: bold;">Accounts Receivable Report Sample</title>
@endsection

@section('reportHeader')
    <table class="fs-lead">
        <thead>
            <tr>
                <th style="width: 17%">REPORT TYPE :</th>
                <td class="border-bottom tx-center" style="width: auto">ACCOUNTS RECEIVABLE REPORT</td>
                <td style="width: 16px"></td>
                <th style="width: 10%">DATES :</th>
                <td class="border-bottom tx-center" style="width: 30%">
                    01 Mar 2022
                    <strong>to</strong>
                    31 Mar 2022

                </td>
            </tr>
        </thead>
    </table>
@endsection

@section('content')
    <table id="accountsReceivable">
        <thead>
            <tr>
                <th style="width: 8%">Number</th>
                <th>Particulars</th>
                <th style="width: 6%">Terms</th>
                <th style="width: 10%">Billing Date</th>
                <th style="width: 10%">Due Date</th>
                <th style="width: 12%">Amount</th>
                <th style="width: 12%">Payment</th>
                <th style="width: 12%">Outstanding</th>
                <th style="width: 12%">Overdue</th>
            </tr>
        </thead>
        <tbody>
        @if($receivables)
            @foreach($receivables as $receivable)
                <tr>
                    <td>{{$receivable->billing_no}}</td>
                    <td><span style="float: left;padding-left:10px;">{{$receivable->particulars}}</span></td>
                    <td>{{$receivable->terms.' '.$receivable->unit}}</td>
                    <td>{{$receivable->billingDate}}</td>
                    <td>
                        <?php
                            echo $receivable->isOverDue ? $receivable->overDueDate : $receivable->dueDate;
                        ?>
                    </td>
                    <td><span style="float: right;padding-right:10px;">{{$receivable->amountDetails}}</span></td>
                    <td><span style="float: right;padding-right:10px;">{{$receivable->payment}}</span></td>
                    <td><span style="float: right;padding-right:10px;">{{$receivable->outstanding}}</span></td>
                    <td><?php echo $receivable->overDueRange; ?></td>
                </tr>
            @endforeach
        @endif
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        </tbody>
    </table>

    <table id="arCountTotal">
        <tr>
            <th style="width: 15%">Count: </th>
            <th>Total: </th>
        </tr>
    </table>
@endsection
