<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    @yield('reportTitle')
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: sans-serif;
        }
        body {
            padding: 150px 48px 36px;
            font-size: 9pt;
        }
        header {
            position: fixed;
            top: 36px;
            left: 36px;
            bottom: 0;
            right: 0;
        }
        main {
            padding: 16px 0;
            height: 80%;
        }
        footer {
            top: auto;
            left: 0;
            right: 0;
            bottom: 16px;
            position: fixed;
        }
        footer *{
            font-size: 10px;
        }
        table {
            margin: 0;
            width: 100%;
        }
        table td, table th {
            vertical-align: middle;
            text-align: left;
        }
        .border-top {
            border-top: 1px solid #1a202c
        }
        .border-bottom {
            border-bottom: 1px solid #1a202c
        }
        .tx-center {
            text-align: center;
        }
        .tx-right {
            text-align: right;
        }
        .fw-bold, .fw-bold *{
            font-weight: bold;
        }
        .fs-lead, .fs-lead * {
            font-size: 11pt;
        }

        .tx-right-indented {
            text-align: right !important;
            padding-right:20px !important;
        }

        .tx-right-indented-10 {
            text-align: right !important;
            padding-right:10px !important;
        }

        .tx-left {
            text-align: left !important;
            padding-left:10px !important;
        }
    </style>
</head>
<body>
<header class="header">
    <table>
        <tr>
            <td>
                <img src="{{ storage_path().'/app/public/images/logo_fujitrans_vertical.jpg' }}" alt=""
                     style="width: 100px">
            </td>
            <td class="tx-center">
                <h1>FUJITRANS LOGISTICS PHILIPPINES, INC.</h1>
                <p>2/F unit 210-211 Crosstown Mall, 8005 National Road, Brgy. Pulong Sta Cruz, Sta Rosa City Laguna</p>
                <p>Telephone Nos.: (049) 832-1876 / (049) 832-1892 / (02) 938-7571 / (02) 938-7572 / (02) 938-7546</p>
                <p>VAT REG. TIN: 008-956-098-00000</p>
            </td>
        </tr>
    </table>
</header>
<main class="container">
<div style="margin-top: -16px">
    @yield('reportHeader')
</div>

    @yield('content')
</main>
</body>
</html>
