@extends('RequestBuilder/layout.master')
@section('pageTitle')
    <title>Dashboard</title>
@endsection
@section('metaCSRF')
    <meta name="csrf-token" content="{{ csrf_token() }}">
@endsection
@section('contents')
    <div class="row m-3 p-3">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Request Builder</h5>
                </div>
                <div class="card-body p-4">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#request-builder" type="button" role="tab" aria-controls="request-builder" aria-selected="true">
                                Request Builder
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                                Namespace
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="false">Controller</button>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="request-builder" role="tabpanel" aria-labelledby="home-tab">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="border mt-4 p-4">
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="request-value">Request</label>
                                                    <input id="request-value" type="text" class="form-control form-control-sm" value="" />
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="type-value">Type</label>
                                                    <input id="type-value" type="text" class="form-control form-control-sm" value="" placeholder="Input [param] type here..."/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="request-table">Table</label>
                                                    <select id="request-table" class="form-control form-control-sm">
                                                        <option value="">--select table--</option>
                                                        @foreach($tables as $table)
                                                            <option value="{{$table['name']}}">{{$table['name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="namespace-value">Namespace</label>
                                                    <select id="namespace-value" class="form-control form-control-sm">
                                                        <option value="">--select namespace--</option>
                                                        @foreach($namespaces as $namespace)
                                                            <option value="{{$namespace->id}}">{{$namespace->namespace}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="request-value">Controller</label>
                                                    <input id="controller-value" type="text" class="form-control form-control-sm" value="" placeholder="Input controller here..." />
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="type-value">Function</label>
                                                    <input id="function-value" type="text" class="form-control form-control-sm" value="" placeholder="Input function here..."/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-12">
                                                <div class="form-group">
                                                    <label for="condition-value">Condition</label>
                                                    <input id="condition-value" type="text" class="form-control form-control-sm" value="" placeholder="Input conditions here..." />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <button id="save-request" type="button" class="btn btn-success btn-sm">Save/Update</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="mt-4">
                                        <table class="table table-hover table-bordered">
                                            <thead>
                                            <tr>
                                                <th>Field Name</th>
                                                <!--<th>Queries</th>-->
                                                <th>Type</th>
                                                <th>Property</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tbody-data">
                                            <tr>
                                                <td><input type="text" class="form-control form-control-sm" /></td>
                                                <!--<td><input type="text" class="form-control form-control-sm" /></td>-->
                                                <td><input type="text" class="form-control form-control-sm" /></td>
                                                <td><input type="text" class="form-control form-control-sm" /></td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-0 mt-4">
                                <table class="table table-bordered table-hover" id="request-services-table">
                                    <thead>
                                    <tr class="text-center">
                                        <th>id</th>
                                        <th>Request</th>
                                        <th>Type</th>
                                        <th>Table</th>
                                        <th>Conditions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($request_services as $fields)
                                        <tr id="{{$fields->id}}" style="cursor: pointer;">
                                            <td>{{$fields->id}}</td>
                                            <td id="request_name">{{$fields->request}}</td>
                                            <td id="request_type">{{$fields->type}}</td>
                                            <td>{{$fields->table}}</td>
                                            <td>{{$fields->conditions}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="border mt-4 p-4">
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="request-value">Namespace</label>
                                                    <input id="request-value" type="text" class="form-control form-control-sm" value="" placeholder="Input [param] request here..." />
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="type-value">Type</label>
                                                    <input id="type-value" type="text" class="form-control form-control-sm" value="" placeholder="Input [param] type here..."/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <table class="table table-hover table-bordered">
                                            <thead>
                                            <tr>
                                                <th>Field Name</th>
                                                <th>Queries</th>
                                                <th>Type</th>
                                                <th>Property</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td><input type="text" class="form-control form-control-sm" /> </td>
                                                <td><input type="text" class="form-control form-control-sm" /></td>
                                                <td><input type="text" class="form-control form-control-sm" /></td>
                                                <td><input type="text" class="form-control form-control-sm" /></td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">...3</div>
                    </div>
                </div>
            </div>
            <label for="table-data"></label><textarea id="table-data" style="display: none;">{{json_encode($tables)}}</textarea>
        </div>
    </div>
@endsection
@section('js')
    <script>
        let tables = JSON.parse($('#table-data').val());
        // let types = ['add', 'update', 'delete', 'list', 'all', 'get'];
        let columns = [];
        let params = {};
        let request_fields = [];
        let request_field_values = {!! json_encode($req_fields) !!};
        let request_services = {!! json_encode($request_services) !!};

        function displayTable() {
            let val = $(this).val();
            $('#tbody-data').html('');
            if($('#condition-value').val() === 'none') $('#tbody-data').html('');
            else {
                for(num in tables){
                    if(tables[num].name === val){
                        console.log(tables[num].columns);
                        generateColumnTable(tables[val].request_fields, tables[num].columns, null);
                        break;
                    }
                }
            }
        }

        $('#request-table').change(displayTable);
        $('#condition-value').on('input', function(){
            if($('#condition-value').val() === 'none') $('#tbody-data').html('');
        });

        function generateColumnTable(req_fields, columns, type){
            let tbody = '';
            console.log(columns)
            for(num in columns){
                let chk = 'checked';
                let selected = 'selected';
                let rows ='<tr>' +
                            '<td>' +
                            '<label>' +
                            '<input type="checkbox" class="column_query" style="padding-right:5px;" id="'+columns[num]+'"/> '+columns[num]+
                            '</label>' +
                            '</td>'+
                            '<td>' +
                            '<select class="form-select form-select-sm" id="'+columns[num]+'_type">' +
                            '<option value="string">string</option>' +
                            '<option value="integer">integer</option>' +
                            '<option value="array">array</option>' +
                            '<option value="file">file</option>' +
                            '</select>' +
                            '</td>' +
                            '<td>' +
                            '<select class="form-select form-select-sm" id="'+columns[num]+'_property">' +
                            '<option value="required">required</option>' +
                            '<option value="nullable">nullable</option>' +
                            '</select>' +
                            '</td></tr>';
                       tbody += rows;
            }
            $('#tbody-data').html(tbody);
                for(num in columns) {
                    req_fields.forEach((fields) => {
                        if (fields.field === columns[num]) {
                            $("#" + columns[num] + "_type").val(fields.type);
                            $("#" + columns[num] + "_property").val(fields.property);
                        }
                        if (fields.field === columns[num] && fields.query.includes(type)) {
                            $("#" + columns[num]).prop('checked', true);
                        }
                    });
                }
        }

        function saveRequest(){
            params['table'] = $('#request-table').val();
            params['request'] = $('#request-value').val();
            params['type'] = $('#type-value').val();
            params['namespace'] = $('#namespace-value').val();
            params['controller'] = $('#controller-value').val();
            params['function'] = $('#function-value').val();
            params['conditions'] = $('#condition-value').val();
            $.ajax({
                url: '/save-request',
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                type:'POST',
                data: { params: params, columns: columns},
                error:function(err){
                    console.error(err);
                    columns = [];
                    alert('ERROR: Something went wrong!');
                },
                success:function(data){
                    alert('SUCCESS: Successfully added or updated!');
                    columns = [];
                    console.log(data);
                    $("#request-services-table").load(location.href + " #request-services-table");
                },
                complete:function(e){
                    console.log(e);
                }
            });
        }

        $('#save-request').on('click', function (e){
           e.preventDefault();
            addChecked();
            saveRequest();
        });

        $(document).on('click', "#request-services-table tbody tr", function() {
            let id = $(this).attr('id');
            let request_name = $('#'+ id + ' #request_name').text();
            let request_type = $('#' + id + ' #request_type').text();
            displaySelectedRowData(request_name, request_type);
        });

        $(document).on('click','.column_query',function (){
            let col = $(this).attr("id");
            let type = $('#'+col+'_type').val();
        })
        function addChecked() {
            $("input:checkbox").each(function () {
                let cBox = $(this);
                if (cBox.is(":checked")) {
                    const cBoxId = cBox.attr("id");
                    // const cBoxValue = $('#'+ cBoxId +'_value').val();
                    const cBoxType = $('#'+ cBoxId +'_type').val();
                    const cBoxProp = $('#'+ cBoxId +'_property').val();
                    const strData = cBoxId + ':' + cBoxType + ':' + cBoxProp;
                    columns.push(strData);
                }
            });
        }

        $('#type-value').on('input', function () {
            let type = $('#type-value').val();
            let request = $('#request-value').val();
            displaySelectedRowData(request, type);
        })

        function displaySelectedRowData(request, type) {
            request_services.forEach((service) => {
                if(service.request === request && service.type === type) {
                    setData(service);
                }
            });
        }

        function setData(service) {
            $('#request-value').val(service.request);
            $('#type-value').val(service.type);
            $('#request-table').val(service.table);
            $('#namespace-value').val(service.namespace);
            $('#controller-value').val(service.controller);
            $('#function-value').val(service.function);
            $('#condition-value').val(service.conditions);

            generateColumnTable(tables[service.table].request_fields, tables[service.table].columns, service.type)
        }
    </script>
@endsection
