<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VOFSampleData extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            "trans_no" => "TR20240100002",
            "trans_date" => "2024-01-02",
            "customer_code" => "C0002",
            "particulars" => "",
            "terms" => 15,
            "unit" => "days",
            "due_date" => "2024-02-02",
            "amount" => 1050304.91,
            "remarks" => "",
            "status" => 1,
            "file" => ""
        ];

        $details = [
        [
            "trans_no" => "TR20240100002",
            "type" => "details",
            "quantity" => 4,
            "vof_no" => "GMBC23459",
            "so_no" => "019566",
            "particulars" => "STRADA GLS 2WD AT",
            "measurement" => "69.12",
            "remarks" => "",
            "amount" => 89488.72,
            "status" => 1
        ],
        [
            "trans_no" => "TR20240100002",
            "type" => "details",
            "quantity" => 4,
            "vof_no" => "GMBC23459",
            "so_no" => "019566",
            "particulars" => "XPANDER GLX AT",
            "measurement" => "28.14",
            "remarks" => "",
            "amount" => 102861.31,
            "status" => 1
        ],
        [
            "trans_no" => "TR20240100002",
            "type" => "details",
            "quantity" => 4,
            "vof_no" => "GMBC23459",
            "so_no" => "019566",
            "particulars" => "STRADA GLS 2WD MT",
            "measurement" => "51.84",
            "remarks" => "",
            "amount" => 289488.72,
            "status" => 1
        ],
        [
            "trans_no" => "TR20240100002",
            "type" => "details",
            "quantity" => 4,
            "vof_no" => "GMBC23459",
            "so_no" => "019566",
            "particulars" => "MONTERO GLX 2PT 2WD MT",
            "measurement" => "32.14",
            "remarks" => "",
            "amount" => 389488.72,
            "status" => 1
        ],
        [
            "trans_no" => "TR20240100002",
            "type" => "details",
            "quantity" => 4,
            "vof_no" => "GMBC23459",
            "so_no" => "019566",
            "particulars" => "MIRAGE G4 GLX CVT",
            "measurement" => "10.89",
            "remarks" => "",
            "amount" => 89488.72,
            "status" => 1
        ],
        [
            "trans_no" => "TR20240100002",
            "type" => "details",
            "quantity" => 4,
            "vof_no" => "GMBC23459",
            "so_no" => "019566",
            "particulars" => "MIRAGE G4 GLX MT",
            "measurement" => "10.89",
            "remarks" => "",
            "amount" => 89488.72,
            "status" => 1
        ],
    ];
        DB::table("tbl_operation_trans")->insert($data);

        foreach($details as $detail) {
            DB::table("tbl_operation_trans_details")->insert($detail);
        }
    }
}
