<?php

namespace Database\Seeders;

use Base\Tables\RequestServices;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RequestServicesSeeder extends Seeder
{
    public function run(): void
    {
        $requestServices = [
            [
                'request' => 'account_setup',
                'type' => 'add',
                'table' => 'tbl_chart_of_accounts',
                'namespace' => '1',
                'controller' => 'ChartOfAccounts',
                'function' => 'main',
                'conditions' => 'values'
            ],
            [
                'request' => 'account_setup',
                'type' => 'list',
                'table' => 'tbl_chart_of_accounts',
                'namespace' => '1',
                'controller' => 'ChartOfAccounts',
                'function' => 'main',
                'conditions' => 'none'
            ],
            [
                'request' => 'account_setup',
                'type' => 'get',
                'table' => 'tbl_chart_of_accounts',
                'namespace' => '1',
                'controller' => 'ChartOfAccounts',
                'function' => 'main',
                'conditions' => 'conditions'
            ],
            [
                'request' => 'account_setup',
                'type' => 'update',
                'table' => 'tbl_chart_of_accounts',
                'namespace' => '1',
                'controller' => 'ChartOfAccounts',
                'function' => 'main',
                'conditions' => 'values, conditions'
            ],
            [
                'request' => 'entities',
                'type' => 'add',
                'table' => 'tbl_entities',
                'namespace' => '2',
                'controller' => 'Entities',
                'function' => 'main',
                'conditions' => 'values'
            ]
        ];
        foreach($requestServices as $requestService){
            RequestServices::query()->insert($requestService);
        }
    }
}
