<?php

namespace Database\Seeders;

use Base\Tables\RequestFields;
use Illuminate\Database\Seeder;

class RequestFieldsSeeder extends Seeder
{
    public function run(): void
    {
        $requestFields = [
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update,get,delete',
                'field' => 'code',
                'type' => 'string',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update,get',
                'field' => 'parent',
                'type' => 'string',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update,get',
                'field' => 'type',
                'type' => 'string',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update',
                'field' => 'title',
                'type' => 'string',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update',
                'field' => 'normal_balance',
                'type' => 'string',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update',
                'field' => 'node',
                'type' => 'integer',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update',
                'field' => 'level',
                'type' => 'integer',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update',
                'field' => 'order',
                'type' => 'integer',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_chart_of_accounts',
                'query' => 'add,update',
                'field' => 'status',
                'type' => 'integer',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_entities',
                'query' => 'add,update,get,delete',
                'field' => 'code',
                'type' => 'string',
                'property' => 'required'
            ],
            [
                'table' => 'tbl_entities',
                'query' => 'add,update',
                'field' => 'type',
                'type' => 'string',
                'property' => 'nullable'
            ],
            [
                'table' => 'tbl_entities',
                'query' => 'add,update',
                'field' => 'category',
                'type' => 'string',
                'property' => 'nullable'
            ],
            [
                'table' => 'tbl_entities',
                'query' => 'add,update',
                'field' => 'name',
                'type' => 'string',
                'property' => 'nullable'
            ],
            [
                'table' => 'tbl_entities',
                'query' => 'add,update',
                'field' => 'status',
                'type' => 'integer',
                'property' => 'nullable'
            ],
            [
                'table' => 'tbl_entities',
                'query' => 'add,update',
                'field' => 'details',
                'type' => 'array',
                'property' => 'nullable'
            ]
        ];
        foreach($requestFields as $requestField){
            RequestFields::query()->insert($requestField);
        }
    }
}
