<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_journal_entries', function (Blueprint $table) {
            $table->id();
            $table->string('journal_code');
            $table->string('acc_code');
            $table->string('code')->nullable();
            $table->string('particulars')->nullable();
            $table->string('debit_credit');
            $table->string('amount');
            $table->string('remarks')->nullable();
            $table->string('status')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_journal_entries');
    }
};
