<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_subsidiary_ledgers', function (Blueprint $table) {
            $table->id();
            $table->string('gl_id')->index();
            $table->string('gl_code')->index()->nullable();
            $table->string('sl_code')->index();
            $table->date('transaction_date');
            $table->dateTime('posted_date')->nullable();
            $table->string('acc_code');
            $table->string('debit_credit');
            $table->decimal('amount');
            $table->decimal('beginning_balance');
            $table->decimal('ending_balance');
            $table->string('particulars')->nullable();
            $table->integer('status');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_subsidiary_ledgers');
    }
};
