<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_general_ledgers', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique()->index()->nullable();
            $table->string('journal_code');
            $table->date('transaction_date')->nullable();
            $table->dateTime('posted_date')->nullable();
            $table->string('acc_code')->index();
            $table->string('description')->nullable();
            $table->string('debit_credit');
            $table->decimal('amount');
            $table->decimal('beginning_balance');
            $table->decimal('ending_balance');
            $table->string('status');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_general_ledgers');
    }
};
