<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_journal', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique()->index();
            $table->string('type'); // Billing, Receipt, Purchase, Payment, General
            $table->date('entry_date');
            $table->date('transaction_date');
            $table->string('entity'); // Customer, Supplier
            $table->string('reference_number')->nullable();
            $table->decimal('amount');
            $table->string('particulars')->nullable();
            $table->string('status')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_journal');
    }
};
