<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_billing', function (Blueprint $table) {
            $table->string("service_type")->nullable()->after("customer_code");
            $table->decimal("vat")->nullable()->after("amount");
            $table->decimal("withholding_tax")->nullable()->after("vat");
            $table->decimal("amount_due")->nullable()->after("withholding_tax");

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_billing', function (Blueprint $table) {
            $table->dropColumn("service_type");
            $table->dropColumn("vat");
            $table->dropColumn("withholding_tax");
            $table->dropColumn("amount_due");
        });
    }
};
