<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_billing', function (Blueprint $table) {
            $table->id();
            $table->string("billing_no")->unique()->index();
            $table->string("transaction_no")->nullable();
            $table->string("customer_code");
            $table->date("billing_date")->nullable();
            $table->date("received_date")->nullable();
            $table->date("due_date")->nullable();
            $table->date("payment_date")->nullable();
            $table->integer("terms")->nullable();
            $table->decimal("amount");
            $table->decimal("payment")->nullable();
            $table->decimal("outstanding")->nullable();
            $table->string("status")->nullable();
            $table->string("particulars")->nullable();
            $table->string("created_by", 100)->nullable();
            $table->string("updated_by", 100)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_billing');
    }
};
