<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_subsidiary_ledger', function (Blueprint $table) {
            $table->id();
            $table->string('acc_code')->index();
            $table->string('sl_code')->index();
            $table->string('type');
            $table->string('desc');
            $table->string('normal_balance');
            $table->integer('status');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subsidiary_ledger');
    }
};
