<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection("sys_base")->create('field_validation_details', function (Blueprint $table) {
            $table->id();
            $table->string("field_validation_code");
            $table->string('type');
            $table->string('value')->nullable();
            $table->boolean("status")->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::connection("sys_base")->dropIfExists('field_validation_details');
    }
};
