<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection("sys_base")->create('validations', function (Blueprint $table) {
            $table->id();
            $table->string("type");
            $table->string("code");
                //validation_rule conforms with laravel validations rules.
                //can create other validations by using laravel's Rule class via php artisan make:rule
            $table->string("rule");
            $table->boolean("with_args")->default(0);
            $table->unsignedInteger("namespace_id")->nullable();
            $table->string("failed_message");
            $table->string("success_message");
            $table->boolean("status")->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::connection("sys_base")->dropIfExists('validations');
    }
};
