<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection("sys_base")->create('form_fields', function (Blueprint $table) {
            $table->id();
            $table->string("form_code");
            $table->string("code");
            $table->string("field_label"); //label to be shown in the form
            $table->string("field_name"); //will be the field name of the data
            $table->string("input_type"); //field_type of the field
            $table->string("sub_field")->nullable(); //this is dependent on object type
            $table->string("field_object_type"); //primitive, object, primitive list, object list
            $table->string("created_by")->nullable();
            $table->string("updated_by")->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::connection("sys_base")->dropIfExists('form_fields');
    }
};
