<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection("sys_base")->create('forms', function (Blueprint $table) {
            $table->id();
            $table->string("code")->index();
            $table->string("form_name");
            $table->string("base_table");
            $table->boolean("status")->default(true);
            $table->string("created_by")->nullable();
            $table->string("updated_by")->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::connection("sys_base")->dropIfExists('forms');
    }
};
