<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_taxes', function (Blueprint $table) {
            $table->id();
            $table->string("code")->index();
            $table->decimal("value");
            $table->string("description");
            $table->string("treatment");
            $table->string("remarks")->nullable();
            $table->string("created_by")->nullable();
            $table->string("updated_by")->nullable();
            $table->unsignedTinyInteger("status")->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_taxes');
    }
};
