<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_operation_trans_details', function (Blueprint $table) {
            $table->id();
            $table->string("trans_no")->index();
            $table->string("type");
            $table->string("particulars")->nullable();
            $table->string("remarks")->nullable();
            $table->decimal("amount");
            $table->string("status")->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_operation_trans_details');
    }
};
