<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_billing_list', function (Blueprint $table) {
            $table->id();
            $table->string("billing_no");
            $table->string("trans_code")->index();
            $table->string("customer_code");
            $table->string("particulars")->nullable();
            $table->date("billing_date");
            $table->integer("terms");
            $table->string("unit");
            $table->date("due_date");
            $table->decimal("amount");
            $table->decimal("payment")->nullable();
            $table->decimal("outstanding")->nullable();
            $table->string("status")->nullable();
            $table->string("created_by", 100)->nullable();
            $table->string("updated_by", 100)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_billing_list');
    }
};
