<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection("sys_base")->create('tbl_addresses', function (Blueprint $table) {
            $table->id();
            $table->string("code")->index();
            $table->string("type");
            $table->string("parent_code")->default("0");
            $table->string("name");
            $table->string("zip_code")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('base_tbl_addresses');
    }
};
