<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_ledgers', function (Blueprint $table) {
            $table->id();
            $table->string('acc_code')->index();
            $table->string('period'); // from setup
            $table->date('posted_date');
            $table->date('trans_from');
            $table->date('trans_to');
            $table->decimal('beginning_balance');
            $table->decimal('ending_balance');
            $table->string('normal_balance');
            $table->integer('status');
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_ledgers');
    }
};
