<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_entries', function (Blueprint $table) {
            $table->id();
            $table->string('acc_code')->index();
            $table->string('trans_code')->index();
            $table->string('original_cur'); // from setup
            $table->string('local_cur'); // from setup
            $table->decimal('oc_value');
            $table->decimal('forex_rate');
            $table->decimal('lc_value');
            $table->decimal('actual_value');
            $table->string('normal_balance');
            $table->string('remarks');
            $table->integer('posted');
            $table->integer('status');
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_entries');
    }
};
