<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_chart_of_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique()->index();
            $table->string('parent');
            $table->string('type'); // from setup
            $table->string('title');
            $table->string('normal_balance'); // from setup
            $table->integer('node');
            $table->integer('level');
            $table->integer('order');
            $table->integer('status');
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_chart_of_accounts');
    }
};
