<?php

use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

function tokenExpiry() : int {
    return env("TOKEN_EXPIRATION", 120);
}

function successResponse($msg, $data) : JsonResponse {
    $response = [
        'code' => 0,
        'status' => "SUCCESS",
        'msg' => $msg,
        'data' => $data,
    ];
    addToLogs($response, "response");
    return response()->json($response, Response::HTTP_OK);
}

function failedResponse($msg, $data, $http_code) : JsonResponse {
    $response = [
        'code' => 1,
        'status' => "FAILED",
        'msg' => $msg,
        'data' => $data,
    ];
    if($msg !== 'Unauthorized') addToLogs($response, "response");
    return response()->json($response, $http_code);
}

function addToLogs($data, $type) : string {
    if($data['code'] === 0) unset($data['data']);
    return createLogs($data,$type);
}

function createLogs($request, $type) : string {
    $log = new \Base\Logs($request, $type);
    return $log->addLog();
}

function requestException() : array{
    return [["none"],["change"]];
}

function parseToColumnName($column) : String {
    $column = preg_replace('/([a-z])([A-Z])/', '$1_$2', $column);
    return strtolower($column);
}

function parseColumns($sections): array {
    $parsedSection = [];
    foreach($sections as $key => $value) $parsedSection[parseToColumnName($key)] = $value;
    return $parsedSection;
}

function dateParse($date, $format) : string {
    return Carbon::parse($date)->format($format);
}
