<?php

namespace Base\Validation;

use Base\Tables\RequestFields;
use Base\Tables\RequestServices;
use Base\Tables\ValidationParams;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;
use function Symfony\Component\String\s;

class RequestValidator
{
    protected $param, $endpoint, $response, $guards, $request;
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */

    public function handle(Request $request, Closure $next, string ...$guards): Response {
        $this->request = $request;
        $this->response = $next($request);
        $this->guards = $guards;
        $this->endpoint = $request->path();
        $this->param = $request->all();
        createLogs($this->param, "request");
        return $this->requestParamValidation();
    }

    private function requestParamValidation() : Response {
        if($this->endpoint === "gateway/auth") return $this->response;
        if (Auth::check()) return $this->getParamValidation();
        else return failedResponse("Error",["response" =>"Unauthenticated."] , 401);
    }

    private function getParamValidation() : Response {
        try{
            $validateParams = $this->checkParam();
            if(in_array($validateParams, requestException())) return $this->response;
            else if($validateParams === 1) return failedResponse("Error",["response" =>"Unexpected variable"] , 422);
            else if($validateParams === 2) return failedResponse("Error",["response" =>"Error on parameter validation implementation"] , 422);
            $param = $this->param;
            $validation = RequestServices::query()->select()->where('request', $param['request'])->first();
            if($validation){
                $required = RequestFields::query()->select('field','type','property')->
                where('query', 'like', '%'.$param['type'].'%')->
                where('table', $validation->table)->get();
                if($required){
                    $requiredColumns = [];
                    foreach ($required as $requiredCol) $requiredColumns[$requiredCol->field] = $requiredCol;
                    $columns = $required->pluck('field')->toArray();
                    $validations = array();
                    foreach($validateParams as $cond) $validations[] = $this->checkVariable($cond,$columns,$requiredColumns);
                    if(in_array(false,$validations )) return failedResponse("Error",["response" =>"Error on Parameter Validation"] , 422);
                    else return $this->response;
                }
                else return failedResponse("Error",["response" =>"Columns not Defined"] , 422);
            }
            return failedResponse("Error",["response" =>"Error on Authentication","data" => $validateParams] , 422);
        }
        catch (\Exception $exception){
            return failedResponse("Error",["response" => $exception->getMessage()] , 422);
        }
    }

    private function checkParam() : array|int {
        $param = $this->param;
        $variableList = RequestServices::query()->select('conditions')
            ->where(['request' => $param['request'],'type' => $param['type']])->first();
        $variableList = explode(',',$variableList->conditions);
        unset($param['request']);
        unset($param['type']);
        unset($param['limit']);
        unset($param['sort']);
        unset($param['key']);
        foreach($variableList as $k => $var) $variableList[$k] = trim($var);
        if($variableList){
            foreach ($param as $key => $val){
                if(!in_array($key, $variableList))
                return 1;
            }
            return $variableList;
        }
        else return 2;


    }

    private function checkVariable($field,$columns,$requiredColumns) : bool {
        $columnValidation = [];
        $param = $this->param;
        if(isset($param[$field])){
            if(sizeof($param[$field]) > 0){
                foreach ($param[$field] as $key => $value){
                    preg_match_all('/[A-Z]/', $key, $matches, PREG_OFFSET_CAPTURE);
                    $col = $key;
                    if(!empty($matches[0][0])) foreach($matches[0] as $match) $col = str_replace($match[0], '_'.strtolower($match[0]), $col);
                    if(!in_array($col,$columns))  return false;
                    if(array_key_exists($col, $requiredColumns)){
                        $c = $requiredColumns[$col];
                        $columnValidation[$field.'.'.$key] = trim($c->property . "|" . $c->type, "|");
                    }
                }
                $this->request->validate($columnValidation);
                return true;
            }
            else return false;
        }
        return false;

    }
}
