<?php

namespace Base\Request;

use Base\DBQueries;
use App\Http\Controllers\Controller;
use Base\Tables\RequestServices;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Base\Tables\ControllerNamespace;

class RequestController extends Controller
{

    protected Request $request;
    protected ?string $controller;
    protected ?string $function;
    protected ?string $table;
    protected ?DBQueries $query;

    public function login(){
        return request();
    }

    public function customRequest (Request $request): ?JsonResponse
    {
        $this->request = $request;
        if($this->requestClass()){
            $controller = $this->controller;
            $function = $this->function;
            return (new $controller)->$function($request);
        }
        return failedResponse("Error",["response" => "Request not defined!"] , 422);
    }

    private function requestClass() : bool {
        $request = $this->request->all();
        $param = RequestServices::query()->where('request',$request['request'])->where('type', $request['type'])->first();
        if($param){
            $this->controller = $this->getNameSpace($param->namespace).$param->controller;
            $this->function = $param->function;
            return true;
        } else return false;
    }

    private function getNameSpace($id) : string {
        $namespace = ControllerNamespace::query()->select()->where('id','=', $id)->first();
        if($namespace)  return str_replace('.', '\\', $namespace->namespace);
        return '';
    }

}
