<?php

namespace Base\Auth;

use Base\Tables\AuthAccessTokens;
use Base\Tables\SystemUsers;
use Base\Tables\UserCredentials;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Http\JsonResponse;

class AuthService
{
    protected $username, $password, $request;

    public function __construct($request){
        date_default_timezone_set("Asia/Manila");
        $this->username = $request->username ?? null;
        $this->password = $request->password ?? null;
        $this->request = $request;
    }

    public function authenticate() : JsonResponse {
        $credentials = $this->verify();
        if(Auth::attempt($credentials)){
            $user = $this->request->user();
            if($this->request->user()->token()) $this->request->user()->token()->revoke();
            $tokenCount = $this->tokenGenerated($user);
            if($tokenCount < $this->getUser()->max_tokens){
                $this->updateLastLogin();
                $tokenResult = $user->createToken('Token');
                $token = $tokenResult->token;
                if ($this->request->remember_me) $token->expires_at = Carbon::now()->addMinute(tokenExpiry());
                $token->save();
                $userDetails = $this->getUser()->toArray();
                unset($userDetails['id']);
                unset($userDetails['max_tokens']);
                return successResponse("Login Successful", [
                    'token' => $tokenResult->accessToken,
                    'expiresAt' => Carbon::parse(Carbon::now()->addMinute(tokenExpiry()))->toDateTimeString(),
                    'loggedUser' => $userDetails
                ]);
            }
            else return failedResponse("Error", ["response" => "Maximum number of token reached (".$this->getUser()->max_tokens.")"], 401);
        }
        else {
            return failedResponse("Login Failed", ["response" => "Invalid Credentials"], 401);
        }
    }

    private function verify() : array {
        $user['name'] = null;
        $user['password'] = null;
        $userData = SystemUsers::query()->select('secret_key')->where(['user_name' => $this->username])->get()->first();
        if($userData){
            $pass =  Crypt::decryptString($userData['secret_key']);
            $userData['pass'] = $pass;
            if($pass == $this->password){
                $user['name'] = $this->username;
                $user['password'] = $userData['secret_key'];
            }
        }
        return $user;
    }

    private function tokenGenerated($user) : int {
        $expireTime = Carbon::now()->format('Y-m-d H:i:s');
        AuthAccessTokens::query()->where('user_id', $user->id)->where('expires_at', '<', $expireTime)->delete();
        return AuthAccessTokens::query()->where('user_id', $user->id)->count();
    }

    public function register() : JsonResponse {
        try {
            $requestData = $this->request;
            $values = $requestData['values'];
            $key = Crypt::encryptString("Bouvet@2023");
            $create = New SystemUsers();
            $create->first_name = $values['firstName'];
            $create->middle_name = $values['middleName'];
            $create->last_name = $values['lastName'];
            $create->user_name = $values['userName'];
            $create->secret_key = $key;
            $create->gender = $values['gender'];
            $create->birthday = $values['birthday'];
            $create->email = $values['email'];
            $create->department = $values['department'];
            $create->employment_status = $values['employmentStatus'];
            $create->max_tokens = 5;
            $create->status = 1;
            $create->save();

            $cred = new UserCredentials();
            $cred->name = $values['userName'];
            $cred->password = bcrypt($key);
            $cred->save();
            return successResponse("User Successful Added", $this->getUser());
        }
        catch (\Exception $exception){
            return failedResponse("Error",["response" => $exception->getMessage()] , 422);
        }

    }

    public function getUser(){
        return SystemUsers::query()->select()->where('user_name', Auth::user()->name)->get()->first();
    }

    public function updateUser(){
        $request = $this->request;
        $conditions = Utility::parseColumns($request['conditions']);
        $values = Utility::parseColumns($request['values']);
        SystemUsers::query()->select()->where($conditions)->update($values);
        return SystemUsers::query()->select()->where($conditions)->get()->first();
    }

    public function changePassword() {
        $response['code'] = 1;
        $response['msg'] = "Invalid Password";
        $request = $this->request;
        $conditions = $request['conditions'];
        $values = $request['values'];
        if($values['newPassword'] === $values['confirmPassword']){
            $userFile = SystemUsers::query()->select('secret_key')->where(['user_name' => $conditions['userName']])->get()->first();
            if($userFile){
                $pass =  Crypt::decryptString($userFile['secret_key']);
                if($pass === $values['oldPassword']){
                    $key = Crypt::encryptString($values['newPassword']);
                    SystemUsers::query()->where(['user_name' => $conditions['userName']])->update(['secret_key' => $key]);
                    UserCredentials::query()->where('name','=',$conditions['userName'])->
                    update(['password' => bcrypt($key)]);
                    $response['code'] = 0;
                    $response['msg'] = "Password Changed Successfully";
                }
            }
        }
        else $response['msg'] = "Password do not match";
        return $response;
    }

    public function getAllUser(){
        return SystemUsers::query()->select()->where('user_name', '!=', Auth::user()->name)->get();
    }

    private function updateLastLogin() : bool {
        return SystemUsers::query()->where('user_name', Auth::user()->name)->update(['last_login' => date('Y-m-d H:i:s')]);
    }
}
