<?php

namespace Base\Auth;

use Base\Auth\AuthService;
use App\Http\Controllers\Controller;
use Base\Tables\SystemUsers;
use Base\Tables\UserCredentials;
use Illuminate\Http\JsonResponse as JRes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class AuthController extends Controller
{
    public function auth(Request $request) : JRes {
        $auth = New AuthService($request);
        return $auth->authenticate();
    }

    public function registerAdmin() : JRes {
        $key = Crypt::encryptString('acctg@2023');
        $create = New SystemUsers();
        $create->first_name = 'Elite';
        $create->last_name = 'Admin';
        $create->user_name = 'admin';
        $create->secret_key = $key;
        $create->gender = 'M';
        $create->birthday = '2018-10-18';
        $create->email = 'acctg@accounting.com';
        $create->max_tokens = 5;
        $create->status = 1;
        $create->save();

        $password = bcrypt($key);
        $cred = new UserCredentials();
        $cred->name = $create->user_name;
        $cred->password = $password;
        $cred->save();

        return response()->json('register', 200);

    }

    public function register(Request $request) : JRes {
        $auth = New AuthService($request);
        return $auth->register();
    }


    public function registerUser($user) : JRes {
        $key = Crypt::encryptString($user);
        $create = New SystemUsers();
        $create->first_name = $user;
        $create->last_name = 'Accounting';
        $create->user_name = $user;
        $create->secret_key = $key;
        $create->gender = 'M';
        $create->birthday = '2018-10-18';
        $create->email = $user.'@accounting.com';
        $create->max_tokens = 3600;
        $create->status = 1;
        $create->save();

        $password = bcrypt($key);
        $cred = new UserCredentials();
        $cred->name = $create->user_name;
        $cred->password = $password;
        $cred->save();

        return response()->json('register', 200);

    }
}
