<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\QueryException;

class Migration extends Controller
{
    //DB Migration
    public function addresses_csv_to_base_addresses() {
        $barangays_file_path = storage_path("/barangays.csv");
        $cities_file_path = storage_path("/cities.csv");
        $provinces_file_path = storage_path("/provinces.csv");
        $regions_file_path = storage_path("/regions.csv");

        try {
            $file = fopen($regions_file_path, "r");

            //excluding header
            fgetcsv($file);

            DB::connection("sys_base")->beginTransaction();

            while ($region_row = fgetcsv($file)) {
                $data = [
                    "code" => (string) $region_row[1],
                    "type" => "region",
                    "parent_code" => "0",
                    "name" => $region_row[0]
                ];

                DB::connection("sys_base")->table("tbl_addresses")->insert($data);
            }

            fclose($file);

            $file = fopen($provinces_file_path, "r");

            //excluded header
            fgetcsv($file);

            while($province_row = fgetcsv($file)) {
                $data = [
                    "code" => (string) $province_row[1],
                    "type" => "province",
                    "parent_code" => (string) $province_row[2],
                    "name" => $province_row[0]
                ];

                DB::connection("sys_base")->table("tbl_addresses")->insert($data);
            }

            fclose($file);

            $file = fopen($cities_file_path, "r");

            //excluded header
            fgetcsv($file);

            while($city_row = fgetcsv($file)) {
                $data = [
                    "code" => (string) $city_row[1],
                    "type" => "city",
                    "parent_code" => (string) $city_row[2],
                    "name" => $city_row[0]
                ];

                DB::connection("sys_base")->table("tbl_addresses")->insert($data);
            }

            fclose($file);

            $file = fopen($barangays_file_path, "r");

            fgetcsv($file);

            while($barangay_row = fgetcsv($file)) {
                $data = [
                    "code" => (string) $barangay_row[1],
                    "type" => "barangay",
                    "parent_code" => (string) $barangay_row[2],
                    "name" => $barangay_row[0]
                ];

                DB::connection("sys_base")->table("tbl_addresses")->insert($data);
            }

            fclose($file);
            DB::connection("sys_base")->commit();
        } catch (QueryException $exception) {
            DB::connection("sys_base")->rollBack();
            echo $exception->getMessage();
        } catch (\Exception $exception) {
            echo $exception->getMessage();
        } catch (\Throwable $e) {
            echo $e->getMessage();
        }
    }
}
