<?php

namespace Accounting\transactions\vouchers;
use Accounting\ParamSetup;
use Carbon\Carbon;
use Illuminate\Database\Query\Builder;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class JournalEntries extends ParamSetup
{
    private string $tbl = 'tbl_journal';
    private Request $request;
    private array $entries;
    private array $ledgers;
    private string $journalCode;

    public function setParams(): array { return ['request' => $this->request, 'table' => $this->tbl]; }

    public function main(Request $request) : JsonResponse{
        date_default_timezone_set("Asia/Manila");
        $this->request = $request;
        $params = $request->all();
        try{
            if($params['type'] === 'post'){
                $param = $params['conditions'];
                $this->journalCode = $param['code'];
                $this->postGeneralLedgers();
                return successResponse("Post", $param);
            }
            else if($params['type'] === 'code'){
                $param = $params['conditions'];
                $code = $this->createJournalCode($param['type']);
                return successResponse("Code", $code);
            }
            else {
                if($this->generateParams()){
                    if($this->action === 'dbInsert'){
                        $this->journalCode = $this->generateCode("JE", 6);
                        $this->addValues('code', $this->journalCode);
                        $this->addValues('status', 'draft');
                        $this->entries = $this->filterRequest();
                        $this->ledgers = $this->createLedgers();
                        $this->execQuery();
                        $this->addJournalDetails();
                        $this->saveLedgers();
                        return successResponse("Success", $this->response);
                    }
                    else if($this->action === 'dbUpdate'){
                        $conditions = $this->conditions;
                        $this->journalCode = $conditions['code'];
                        $this->entries = $this->filterRequest();
                        $this->ledgers = $this->createLedgers();
                        $this->execQuery();
                        $this->updateJournalDetails();
                        $this->updateLedgers();
                        return successResponse("Success", $this->response);
                    }
                    else if($this->action === 'dbDelete'){
                        $conditions = $this->conditions;
                        $this->journalCode = $conditions['code'];
                        $this->execQuery();
                        DB::table('tbl_journal_details')->where('journal_code', $this->journalCode)->update(['deleted_at' => date('Y-m-d H:i:s')]);
                        $this->deleteLedgers('delete');
                        return successResponse("Success", $this->response);
                    }
                    else if($this->action === 'dbGet'){
                        $this->execQuery();
                        $response = $this->response;
                        $entries = DB::table('tbl_general_ledgers')->where('journal_code', $response->code)->get();
                        $entries = $entries->map(function ($entries){
                            $details =  DB::table('tbl_ledger_details')->where('ledger_id', $entries->id)->get();
                            $data = array();
                            foreach($details as $detail){
                                $data[$detail->key] = $detail->value;
                            }
                            return $data;
                        });

                        $response->entries = $entries;
                        return successResponse("Success", $response);
                    }
                    else if($this->action === 'dbGetAll'){
                         if($params['type'] === 'all'){
                             $condition = $this->conditions;
                             $conditions = explode(':',$condition['type']);
                             if($conditions[2] === 'summary'){
                                 $journals = DB::table('tbl_journal')->where('transaction_date','>=',$conditions[0])->where('transaction_date','<=',$conditions[1])
                                     ->get();
                                 $journals = $journals->map(function ($journals){
                                     $types = ["journal" => "JV", "receipt" => "CR", "disbursement" => "CD"];
                                     return [
                                         'entryDate' => Carbon::parse($journals->entry_date)->format('d-M-Y'),
                                         'transDate' => Carbon::parse($journals->transaction_date)->format('d-M-Y'),
                                         'particulars' => $journals->particulars,
                                         'amount' => formatAccountingCurrency($journals->amount),
                                         'type' => $journals->type ? $types[$journals->type] : '',
                                         'status' => $journals->status,
                                         'code' => $journals->code,
                                     ];
                                 });
                                 return successResponse("Success", $journals);
                             }
                             else if($conditions[2] === 'supplier' || $conditions[2] === 'customer'){
                                 $subLedgers = DB::table('tbl_subsidiary_ledgers')->where('sl_code', $conditions[3])->where('transaction_date','>=',$conditions[0])
                                     ->where('transaction_date','<=',$conditions[1])->where('status', 1)->get();
                                 $subLedgers = $subLedgers->map(function ($subLedgers){
                                     $account = DB::table('tbl_chart_of_accounts')->where('code',$subLedgers->acc_code)->first();
                                     $types = ["journal" => "JV", "receipt" => "CR", "disbursement" => "CD"];
                                     $journal = DB::table('tbl_journal')->select()
                                         ->whereRaw("(select count(*) from tbl_general_ledgers where tbl_general_ledgers.journal_code = tbl_journal.code and tbl_general_ledgers.id = ".$subLedgers->gl_id.") > 0")->first();
                                     return [
                                         'postedDate' => Carbon::parse($subLedgers->posted_date)->format('d-M-Y'),
                                         'transDate' => Carbon::parse($subLedgers->transaction_date)->format('d-M-Y'),
                                         'particulars' => $journal?->particulars,
                                         'debit' => $subLedgers->debit_credit === 'Dr' ? formatAccountingCurrency($subLedgers->amount) : '',
                                         'credit' => $subLedgers->debit_credit === 'Cr' ? formatAccountingCurrency($subLedgers->amount) : '',
                                         'endingBalance' => formatAccountingCurrency($subLedgers->ending_balance),
                                         'type' => $journal ? $types[$journal->type] : '',
                                         'status' => $subLedgers->status,
                                         'account' => $account? '['.$account->custom_code.'] '.$account->title : null,
                                         'code' => $journal?->code,
                                     ];
                                 });
                                 return successResponse("Success", $subLedgers);
                             }
                         }
                        $this->execQuery();
                        $response = $this->response;
                        $response->map(function ($response){
                            $response->entry_date = Carbon::parse($response->entry_date)->format('d-M-Y');
                            $response->transaction_date = Carbon::parse($response->transaction_date)->format('d-M-Y');
                            $response->amount = number_format($response->amount,2,'.',',');
                        });
                        return successResponse("Success", $response);
                    }
                }
            }
        }
        catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return successResponse("FAILED", $this->response);
    }
    private function createLedgers() : array {
        $values = $this->values;
        $entries = $this->entries;
        $ledgers = array();
        if($values['type'] === 'receipt' || $values['type'] === 'disbursement' || $values['type'] === 'journal'){
            foreach($entries as $entry){
                foreach($entry['debit'] as $debit){
                    $ledgers[] = $this->addLedger($values,$debit);
                }
                foreach($entry['credit'] as $credit){
                    $ledgers[] = $this->addLedger($values,$credit);
                }
            }
        }
        return $ledgers;
    }
    private function addLedger($values, $entry) : array {
        $ledger['transaction_date'] = $values['transaction_date'];
        $ledger['journal_code'] = $this->journalCode;
        $ledger['acc_code'] = $entry['account'];
        $ledger['description'] = $entry['description'] ?? null ; //$entry['type'] === 'receipt' ? $entry['document'] : null;
        $ledger['debit_credit'] = $entry['normalBalance'];
        $ledger['amount'] = $entry['amount'];
        $ledger['beginning_balance'] = 0;
        $ledger['ending_balance'] = 0;
        $ledger['status'] = "draft";
        $ledger['created_at'] = date('Y-m-d H:i:s');
        $ledger['updated_at'] = date('Y-m-d H:i:s');
        $ledger['details'] = array();
        foreach($entry as $key => $value){
            $ledger['details'][$key] = $value;
        }
        $entryTypes = ["transaction","journal"];
        if(in_array($entry['type'], $entryTypes)){
            if(isset($entry['entity'])){
                $slCode = $entry['entity'];
                $ledger['subsidiary'] = $this->addSubLedger($values, $entry, $slCode);
            }
            if($values['entity'] && $values['entity'] !== 'NA'){
                $slCode = $values['entity'];
                $ledger['subsidiary'] = $this->addSubLedger($values, $entry, $slCode);
            }
        }
        //        if($entry['type'] === 'transaction'){
        //            $subLedger['gl_id'] = null;
        //            $subLedger['gl_code'] = null;
        //            $subLedger['sl_code'] = $values['entity'];
        //            $subLedger['transaction_date'] = $values['transaction_date'];
        //            $subLedger['acc_code'] = $entry['account'];
        //            $subLedger['debit_credit'] = $entry['normalBalance'];
        //            $subLedger['amount'] = $entry['amount'];
        //            $subLedger['beginning_balance'] = 0;
        //            $subLedger['ending_balance'] = 0;
        //            $subLedger['particulars'] = $values['particulars'];;
        //            $subLedger['status'] = 0;
        //            $ledger['subsidiary'] = $subLedger;
        //        }
        return $ledger;
    }
    private function addSubLedger($values, $entry, $slCode) : array {
        $subLedger['gl_id'] = null;
        $subLedger['gl_code'] = null;
        $subLedger['sl_code'] = $slCode;
        $subLedger['transaction_date'] = $values['transaction_date'];
        $subLedger['acc_code'] = $entry['account'];
        $subLedger['debit_credit'] = $entry['normalBalance'];
        $subLedger['amount'] = $entry['amount'];
        $subLedger['beginning_balance'] = 0;
        $subLedger['ending_balance'] = 0;
        $subLedger['particulars'] = $values['particulars'];;
        $subLedger['status'] = 0;
        $subLedger['created_at'] = date('Y-m-d H:i:s');
        $subLedger['updated_at'] = date('Y-m-d H:i:s');
        return $subLedger;
    }
    private function saveLedgers() : void {
        $ledgers = $this->ledgers;
        foreach ($ledgers as $ledger){
            $details = $ledger['details'];
            $subsidiary = $ledger['subsidiary'] ?? null;
            unset($ledger['details']);
            unset($ledger['subsidiary']);
            $ledgerId = DB::table('tbl_general_ledgers')->insertGetId($ledger);
            if($subsidiary){
                $subsidiary['gl_id'] = $ledgerId;
                DB::table('tbl_subsidiary_ledgers')->insert($subsidiary);
            }
            if($details){
                foreach($details as $key => $value){
                    $detail['ledger_id'] = $ledgerId;
                    $detail['ledger_code'] = null;
                    $detail['type'] = 'GL';
                    $detail['key'] = $key;
                    $detail['value'] = $value;
                    $detail['status'] = 'draft';
                    $detail['created_at'] = date('Y-m-d H:i:s');
                    $detail['updated_at'] = date('Y-m-d H:i:s');
                    DB::table('tbl_ledger_details')->insert($detail);
                }
            }
        }
        $this->response = $ledgers;
    }
    private function updateLedgers() : void {
        $this->deleteLedgers('update');
        $this->saveLedgers();
    }
    private function deleteLedgers($action) : void {
        $ledgers = DB::table('tbl_general_ledgers')->where('journal_code', $this->journalCode)->get();
        if($ledgers){
            foreach($ledgers as $ledger){
                $SL = DB::table('tbl_subsidiary_ledgers')->where('gl_id', $ledger->id)->where('status', 0);
                $GL = DB::table('tbl_general_ledgers')->where('id', $ledger->id)->where('status', 'draft');
                if($action === 'delete'){
                    $SL->update(['deleted_at' => date('Y-m-d H:i:s')]);
                    $GL->update(['deleted_at' => date('Y-m-d H:i:s'), 'status' => 'deleted']);
                }
                else if($action === 'update'){
                    $SL->delete();
                    $GL->delete();
                }
            }
        }
    }
    private function postGeneralLedgers() : void {
        $ledgers = DB::table('tbl_general_ledgers')->where('journal_code', $this->journalCode)->get();
        if($ledgers){
            foreach($ledgers as $ledger){
                $normalBalance = DB::table('tbl_chart_of_accounts')->where('code', $ledger->acc_code)->first();
                if($normalBalance){
                    $balances = DB::table('tbl_general_ledgers')->where('acc_code', $ledger->acc_code)->where('status','posted')->orderByDesc('code')->first();
                    $beginningBalance = $balances ? $balances->ending_balance : 0;
                    $normalBalance = $normalBalance->normal_balance;
                    if($normalBalance === $ledger->debit_credit) $endingBalance = $beginningBalance + $ledger->amount;
                    else $endingBalance = $beginningBalance - $ledger->amount;
                    $GLCode = $this->generateCode("GL", 6);
                    DB::table('tbl_general_ledgers')->where('id', $ledger->id)->update([
                        'beginning_balance' => $beginningBalance,
                        'ending_balance' => $endingBalance,
                        'code' => $GLCode,
                        'posted_date' => date('Y-m-d H:i:s'),
                        'status' => 'posted'
                    ]);
                    $subsidiaries = DB::table('tbl_subsidiary_ledgers')->where('gl_id', $ledger->id)->get();
                    foreach($subsidiaries as $subsidiary){
                        $normalBalance = DB::table('tbl_chart_of_accounts')->where('code', $subsidiary->acc_code)->first();
                        if($normalBalance){
                            $slBalances = DB::table('tbl_subsidiary_ledgers')->where('sl_code', $subsidiary->sl_code)
                                ->where('acc_code', $subsidiary->acc_code)->where('status', 1)->orderByDesc('id')->first();
                            $slBeginningBalance = $slBalances ? $slBalances->ending_balance : 0;
                            $normalBalance = $normalBalance->normal_balance;
                            if($normalBalance === $subsidiary->debit_credit) $endingBalance = $slBeginningBalance + $subsidiary->amount;
                            else $endingBalance = $slBeginningBalance - $subsidiary->amount;
                            DB::table('tbl_subsidiary_ledgers')->where('id', $subsidiary->id)->update([
                                'beginning_balance' => $slBeginningBalance,
                                'ending_balance' => $endingBalance,
                                'gl_code' => $GLCode,
                                'posted_date' => date('Y-m-d H:i:s'),
                                'status' => 1
                            ]);
                        }
                    }
                }
            }
            DB::table('tbl_journal')->where('code', $this->journalCode)->update([
                'status' => 'posted'
            ]);
        }
    }
    private function addJournalDetails() : void {
        $values = $this->values;
        foreach($values as $key => $value){
            if($key !== 'code'){
                $journal['journal_code'] = $this->journalCode;
                $journal['key'] = $key;
                $journal['value'] = $value;
                $journal['particulars'] = null;
                $journal['status'] = 0;
                $journal['created_at'] = date('Y-m-d H:i:s');
                $journal['updated_at'] = date('Y-m-d H:i:s');
                DB::table('tbl_journal_details')->insert($journal);
            }
        }
    }
    private function updateJournalDetails() : void {
        $values = $this->values;
        foreach($values as $key => $value){
            if($key !== 'code'){
                DB::table('tbl_journal_details')->where('journal_code', $this->journalCode)
                    ->where('key', $key)
                    ->update(['value' => $value]);
            }
        }
    }
    public function createJournalCode($type) : string {
        $codeType = ["journal" => "JV","disbursement" => "CD","receipt" => "CR","billing" => "BL","collection" => "CL"];
        $currentMonth = date('Ym');
        $code = $codeType[$type].'-'.$currentMonth.'-0001';
        $voucher = DB::table('tbl_journal')->select('reference_number')->whereNotNull('code')
            ->where('type', $type)->orderByDesc('code')->first();
        if($voucher){
            $temp = $voucher->reference_number;
            $temp = explode('-',$temp);
            if(isset($temp[2])){
                if($currentMonth === $temp[1]){
                    $series = (int) $temp[2] + 1;
                    $value = str_pad($series, 4, '0', STR_PAD_LEFT);
                    $code = $codeType[$type].'-'.$currentMonth.'-'.$value;
                }
            }
        }
        return $code;
    }
}
