<?php

namespace Accounting\transactions\receivable;

use Accounting\transactions\vouchers\JournalEntries;
use Accounting\ParamSetup;
use Base\DBQueries;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Billings extends ParamSetup
{
    private string $tbl = 'tbl_billing';
    private Request $request;
    private ?array $items;
    private ?array $details;
    private ?string $billingCode;

    private ?string $journalCode;

    public function setParams(): array { return ['request' => $this->request, 'table' => $this->tbl];}

    public function main(Request $request) : JsonResponse {
        $param = $request->all();
        $this->request = $request;
        if($param['request'] == 'transaction_billing_setup'){
            $conditions = $param['conditions'];
            $list = DB::table('tbl_billing_transaction_map')->where($conditions)->orderBy('sequence')->get();
            return successResponse("Success", $list);
        }
        else if($param['request'] == 'transaction_billings'){
            if($param['type'] == 'code'){
                $code = (new JournalEntries)->createJournalCode('billing');
                return successResponse("Success",$code);
            }
            else if($param['type'] == 'post'){
                $this->conditions = $param['conditions'];
                return successResponse("Success",$this->createJournalEntries());
            }
            else if($param['type'] == 'reverse'){
                $this->conditions = $param['conditions'];
                return successResponse("Success",$this->reverseJournalEntries('approved'));
            }
            else if($param['type'] == 'billing_code'){
                $this->billingCode = $param['conditions']['type'];
                return successResponse("Success",$this->checkBillingCode($this->billingCode));
            }
            else {
                if ($this->generateParams()) {
                    if ($param['type'] == 'add') {
                        $action = $this->action;
                        $this->addValues('outstanding', $this->getValue('amount_due'));
                        $this->billingCode = (new JournalEntries)->createJournalCode('billing');
                        $this->journalCode = $this->generateCode("JE", 6);
                        $this->items = $this->getValue('items');
                        $this->addValues('status','draft');
                        $this->removeValueArray('items');
                        $this->removeValueArray('details');
                        $add = new DBQueries($this->table, $this->values, $this->conditions, $this->sort, $this->limit, $this->key);
                        $this->response = $add->$action();
                        $this->addBillingItems();
                        $this->addToJournalEntries();
                        $this->createLedgers($this->values);
                        //$this->saveTransactionCode($this->getValue('transaction_no'),'billings');
                    }
                    else if ($param['type'] == 'update') {
                        $action = $this->action;
                        $this->addValues('outstanding', $this->getValue('amount_due'));
                        $this->billingCode = $this->getValue('billing_no');
                        $this->items = $this->getValue('items');
                        $status = $this->getValue('status');
                        $this->removeValueArray('items');
                        $this->removeValueArray('details');
                        $add = new DBQueries($this->table, $this->values, $this->conditions);
                        $this->response = $add->$action();
                        $this->addBillingItems();
                        $this->updateTransactionCode($this->getValue('transaction_no'),$status);
                        if($status === 'cancelled'){
                            $this->conditions = ['billing_no' => $this->billingCode];
                            $this->reverseJournalEntries($status);
                        }
                    }
                    else if ($param['type'] == 'list') {
                        $action = $this->action;
                        $add = new DBQueries($this->table, null, $this->conditions);
                        $this->response = $add->$action();
                        $this->parseResponse();
                    }
                    else if ($param['type'] == 'get') {
                        $action = $this->action;
                        $add = new DBQueries($this->table, null, $this->conditions);
                        $this->response = $add->$action();
                        $this->parseResponse();
                    }
                }
            }
        }
        return successResponse("Success", $this->response);
    }

    private function addToJournalEntries() {
        $values = $this->values;
        $journal['code'] = $this->journalCode;
        $journal['type'] = 'billing';
        $journal['entry_date'] = $values['billing_date'];
        $journal['transaction_date'] = $values['billing_date'];
        $journal['entity'] = $values['customer_code'];
        $journal['reference_number'] = $this->billingCode;
        $journal['amount'] = $values['amount_due'];
        $journal['particulars'] = $values['particulars'];
        $journal['status'] = 'draft';
        $journal['created_at'] = date('Y-m-d H:i:s');
        $journal['updated_at'] = date('Y-m-d H:i:s');
        DB::table('tbl_journal')->insert($journal);
    }
    private function addBillingItems() : void {
        if($this->action === 'dbUpdate') {
            DB::table('tbl_billing_items')->where($this->conditions)->delete();
        }
        $items = $this->items;
        foreach($items as $key => $item){
            foreach($item as $k => $val){
                $details['billing_no'] = $this->billingCode;
                $details['sequence'] = $key + 1;
                $details['type'] = $k;
                $details['value'] = $k === 'component' ? json_encode($val) : $val;
                $details['status'] = 1;
                $save = new DBQueries('tbl_billing_items', $details);
                $save->dbInsert();
            }
        }
    }

    private function parseResponse() : void {
        $response = $this->response;
        if($this->action === 'dbGetAll'){
            $response->map(function ($response){
                return $this->getDetailResponse($response);
            });
        }
        else {
            $response = $this->getDetailResponse($response);
            if($response){
                $response->customerDetails = DB::table('tbl_entities')->where('code', $response->customer_code)->first();
                $itemDetails = DB::table('tbl_billing_items')->where('billing_no', $response->billing_no)->orderBy('sequence')->get();
                $items = array();
                foreach($itemDetails as $itemDetail){
                    if($itemDetail->type === 'component') $itemDetail->value = json_decode($itemDetail->value, true);
                    $items[$itemDetail->sequence][] = $itemDetail;
                }
                $response->itemDetails = $items;
                $itemHeaders  = DB::table('tbl_templates_details')
                    ->whereRaw("(select count(*) from tbl_templates where tbl_templates.temp_code = tbl_templates_details.template_code and tbl_templates.code = '".$response->service_type."') > 0")
                    ->get();
                $headers = array();
                foreach($itemHeaders as $itemHeader){
                    $item[$itemHeader->type] = $itemHeader->value;
                    $headers[$itemHeader->sub_category] = $item;
                }
                $response->itemHeaders = $headers;
                //DB::table('tbl_billing_transaction_map')->where('type', $response->service_type)->orderBy('sequence')->get();

            }
        }
    }

    private function overDueStatus($response) : ?array {
        $res = array();
        $outstanding = $response->outstanding;
        $overDueDays = Carbon::parse($response->dueDate)->diff(Carbon::now());
        $res['overDueDate'] = '';
        $res['overDueRange'] = '';
        $res['isOverDue'] = false;
        if($outstanding > 0){
            if($overDueDays->invert === 0 && $overDueDays->days > 0){
                if($overDueDays->days <= 30) $res['overDueRange'] = '1-30';
                else if($overDueDays->days <= 60) $res['overDueRange'] = '31-60';
                else if($overDueDays->days <= 90) $res['overDueRange'] = '61-90';
                else if($overDueDays->days <= 120) $res['overDueRange'] = '91-120';
                else $res['overDueRange'] = 'over 120';
                $res['overDueDate'] = '<b style="color:red">'.$response->dueDate.'</b>';
                $res['overDueRange'] = '<b style="color:red">'.$res['overDueRange'].'</b>';
                $res['isOverDue'] = true;
            }
        }
        else $res['overDueRange'] = 'Paid';
        if($response->status === 'cancelled') $res['overDueRange'] = '<b style="color:red">Cancelled</b>';
        return $res;
    }

    public function getDetailResponse($response){
        if(isset($response->billing_no)){
            $response->billingDate = dateParse($response->billing_date,'d-M-Y');
            $response->billingDateDetails = dateParse($response->billing_date,'j F Y');
            $response->dueDate = dateParse($response->due_date,'d-M-Y');
            $response->dueDateDetails = dateParse($response->due_date,'j F Y');
            $response->paymentDate = $response->payment_date ? dateParse($response->payment_date,'d-M-Y') : null;
            $response->receivedDate = $response->received_date ? dateParse($response->received_date,'d-M-Y') : null;
            $response->termsDetails = $response->terms.' days';
            $response->amountDetails = number_format($response->amount, 2, '.',',');
            $response->payment = number_format($response->payment, 2, '.',',');
            $response->vatDetails = number_format($response->vat, 2, '.',',');
            $response->ewtDetails = number_format($response->withholding_tax, 2, '.',',');
            $response->outstanding = number_format($response->outstanding, 2, '.',',');
            $response->amountDue = number_format($response->amount_due, 2, '.',',');
            $overDues = $this->overDueStatus($response);
            $response->overDueDate = $overDues['overDueDate'];
            $response->overDueRange = $overDues['overDueRange'];
            $response->isOverDue = $overDues['isOverDue'];
            return $response;
        }
        return null;

    }

    private function createLedgers($values) : ?array {
        $ledgers = array();
        $subLedgers = array();
        $operations = array();
        $items = $this->items;
        foreach($items as $item){
            foreach($item['component'] as $key => $component){
                if(array_key_exists($key, $operations)) $operations[$key] = $operations[$key] + $component;
                else $operations[$key] = $component;
            }
        }
        $debitAccounts = DB::table('tbl_subsidiary_ledger')->where('type', 'billing')
            ->where('map_table', 'tbl_billing')
            ->where('map_column','amount_due')
            ->where('sl_code',$values['customer_code'])->get();
        $creditAccounts = DB::table('tbl_subsidiary_ledger')
            ->where('type', 'billing')
            ->where('map_table', 'tbl_billing')
            ->where('map_column','!=','amount_due')->get();
        $ledger['transaction_date'] = $values['billing_date'];
        $ledger['journal_code'] = $this->journalCode;
        $sequence = 1;
        foreach($debitAccounts as $debitAccount){
            if($values['amount_due'] > 0) {
                $ledger['sequence'] = $sequence;
                $ledger['acc_code'] = $debitAccount->acc_code;
                $ledger['description'] = $debitAccount->desc;
                $ledger['debit_credit'] = $debitAccount->normal_balance;
                $ledger['amount'] = $values['amount_due'];
                $ledger['subsidiary'] = $this->addSubLedger($ledger, $values['billing_no'], $debitAccount->sl_code);
                $ledger['details'] = $this->createLedgerDetails($ledger, $values['billing_no']);
                unset($ledger['sequence']);
                $ledgers[] = $this->createLedger($ledger);
                $sequence = $sequence + 1;
            }
        }
        foreach($creditAccounts as $creditAccount){
            if($creditAccount->map_column === 'amount') $ledger['amount'] = $operations[$creditAccount->sl_code];
            else $ledger['amount'] = $values[$creditAccount->map_column];
            if($ledger['amount'] > 0){
                $ledger['acc_code'] = $creditAccount->acc_code;
                $ledger['description'] = $creditAccount->desc;
                $ledger['debit_credit'] = $creditAccount->normal_balance;
                $ledger['sequence'] = $sequence;
                $ledger['subsidiary'] = $this->addSubLedger($ledger, $values['billing_no'], $creditAccount->sl_code);
                $ledger['details'] = $this->createLedgerDetails($ledger, $values['billing_no']);
                unset($ledger['sequence']);
                $ledgers[] = $this->createLedger($ledger);
                $sequence = $sequence + 1;
            }
        }
        foreach ($ledgers as $ledger){
            $subsidiary = $ledger['subsidiary'] ?? null;
            $details = $ledger['details'] ?? null;
            unset($ledger['subsidiary']);
            unset($ledger['details']);
            $ledgerId = DB::table('tbl_general_ledgers')->insertGetId($ledger);
            if($subsidiary){
                $subsidiary['gl_id'] = $ledgerId;
                DB::table('tbl_subsidiary_ledgers')->insert($subsidiary);
            }
            if($details){
                foreach($details as $key => $value){
                    $detail['ledger_id'] = $ledgerId;
                    $detail['ledger_code'] = null;
                    $detail['type'] = 'GL';
                    $detail['key'] = $key;
                    $detail['value'] = $value;
                    $detail['status'] = 'draft';
                    $detail['created_at'] = date('Y-m-d H:i:s');
                    $detail['updated_at'] = date('Y-m-d H:i:s');
                    DB::table('tbl_ledger_details')->insert($detail);
                }
            }
        }
        return [$ledgers, $subLedgers];
    }

    private function addSubLedger($values, $billingNo, $slCode) : ?array {
        $isExist = DB::table('tbl_entities')->where('code', $slCode)->count();
        if($isExist === 0){
            $isExist = DB::table('tbl_operations')->where('code', $slCode)->count();
        }
        if($isExist){
            $subLedger['gl_id'] = null;
            $subLedger['gl_code'] = null;
            $subLedger['sl_code'] = $slCode;
            $subLedger['transaction_date'] = $values['transaction_date'];
            $subLedger['acc_code'] = $values['acc_code'];
            $subLedger['debit_credit'] = $values['debit_credit'];
            $subLedger['amount'] = $values['amount'];
            $subLedger['beginning_balance'] = 0;
            $subLedger['ending_balance'] = 0;
            $subLedger['particulars'] = "Billing #: ".$billingNo;
            $subLedger['status'] = 0;
            $subLedger['created_at'] = date('Y-m-d H:i:s');
            $subLedger['updated_at'] = date('Y-m-d H:i:s');
            return $subLedger;
        }
        return null;
    }

    private function createLedger($ledger){
        $ledger['beginning_balance'] = 0;
        $ledger['ending_balance'] = 0;
        $ledger['status'] = "draft";
        $ledger['created_at'] = date('Y-m-d H:i:s');
        $ledger['updated_at'] = date('Y-m-d H:i:s');
        return $ledger;
    }

    private function createLedgerDetails($ledger, $description) : array {
        $accTitle = DB::table('tbl_chart_of_accounts')->where('code',$ledger['acc_code'])->first();
        $details['sequence'] = $ledger['sequence'];
        $details['account'] = $ledger['acc_code'];;
        $details['customCode'] = $accTitle?->custom_code;
        $details['branch'] = "HOF";
        $details['amount'] = $ledger['amount'];
        $details['normalBalance'] = $ledger['debit_credit'];
        $details['accountName'] = $accTitle?->title;
        $details['description'] = "Billing #: ".$description;
        $details['type'] = "billing";
        return $details;
    }
    private function createJournalEntries() : ?array {
        $billing = DB::table('tbl_billing')->where($this->conditions)->first();
        if($billing){
            $amountDue = DB::table('tbl_subsidiary_ledger')->where('type', 'billing')
                ->where('map_table', 'tbl_billing')
                ->where('map_column','amount_due')
                ->where('sl_code',$billing->customer_code);
            $amount = DB::table('tbl_subsidiary_ledger')
                ->where('type', 'billing')
                ->where('map_table', 'tbl_billing')
                ->where('map_column','amount')
                ->where('sl_code',$billing->service_type)
                ->union($amountDue);
            $subAccounts = DB::table('tbl_subsidiary_ledger')
                ->where('type', 'billing')
                ->where('map_table', 'tbl_billing')
                ->where('map_column','!=','amount_due')
                ->where('map_column','!=','amount')
                ->union($amount)->get();
            if($subAccounts){
                $debit = array();
                $credit = array();
                $subLedgers = array();
                foreach($subAccounts as $subAccount){
                    $columns = $subAccount->map_column;
                    $subLedger['acc_code'] = $subAccount->acc_code;
                    $subLedger['trans_code'] = $billing->transaction_no;
                    if(isset($billing->$columns)){
                        if($billing->$columns > 0){
                            if($subAccount->normal_balance === 'Dr'){
                                $debit[] = ['account' => $subAccount->acc_code, 'value' => $billing->$columns];
                                $subLedger['items'] = $this->generateSubsidiaryLedgers($subAccount);
                                $subLedgers[] = $subLedger;
                            }
                            else if($subAccount->normal_balance === 'Cr'){
                                $credit[] = ['account' => $subAccount->acc_code, 'value' => $billing->$columns];
                                $subLedger['items'] = $this->generateSubsidiaryLedgers($subAccount);
                                $subLedgers[] = $subLedger;
                            }
                        }
                    }
                }
                $entryData['Dr'] = $debit;
                $entryData['Cr'] = $credit;
                $entries = array();
                foreach($entryData as $normalBalance => $entryTypes){
                    foreach($entryTypes as $entry){
                        $data['acc_code'] = $entry['account'];
                        $data['trans_code'] = $billing->transaction_no;
                        $data['original_cur'] = 'PHP';
                        $data['local_cur'] = 'PHP';
                        $data['oc_value'] = 1;
                        $data['forex_rate'] = 1;
                        $data['lc_value'] = 1;
                        $data['actual_value'] = (float)(str_replace(',','',$entry['value']));
                        $data['normal_balance'] = $normalBalance;
                        $data['posted'] = 0;
                        $data['status'] = 1;
                        $entries[] = $data;
                    }
                }
                (new JournalEntries)->addEntries($entries);
                (new JournalEntries)->addSubsidiaryEntries($subLedgers);
                DB::table('tbl_billing')->where($this->conditions)->update(['status' => 'posted']);
                $this->updateTransactionCode($billing->transaction_no,'posted');
                return $subLedgers;
            }
        }
        return $billing;
    }
    private function reverseJournalEntries($status) : ?array {
        $billing = DB::table('tbl_billing')->where($this->conditions)->first();
        if($billing){
            $accounts = DB::table('tbl_subsidiary_ledger')->where('type', 'billing')
                ->where('map_table', 'tbl_billing')->where('map_column','!=','amount_due');
            $subAccounts = DB::table('tbl_subsidiary_ledger')->where('type', 'billing')
                ->where('map_table', 'tbl_billing')
                ->where('map_column','amount_due')
                ->where('sl_code',$billing->customer_code)
                ->union($accounts)->get();
            if($subAccounts){
                $debit = array();
                $credit = array();
                foreach($subAccounts as $subAccount){
                    $columns = $subAccount->map_column;
                    if(isset($billing->$columns)){
                        if($billing->$columns > 0){
                            if($subAccount->normal_balance === 'Dr'){
                                $credit[] = ['account' => $subAccount->acc_code, 'value' => $billing->$columns];
                            }
                            else if($subAccount->normal_balance === 'Cr'){
                                $debit[] = ['account' => $subAccount->acc_code, 'value' => $billing->$columns];
                            }
                        }
                    }
                }
                $entryData['Dr'] = $debit;
                $entryData['Cr'] = $credit;
                $entries = array();
                foreach($entryData as $normalBalance => $entryTypes){
                    foreach($entryTypes as $entry){
                        $data['acc_code'] = $entry['account'];
                        $data['trans_code'] = $billing->transaction_no;
                        $data['original_cur'] = 'PHP';
                        $data['local_cur'] = 'PHP';
                        $data['oc_value'] = 1;
                        $data['forex_rate'] = 1;
                        $data['lc_value'] = 1;
                        $data['actual_value'] = (float)(str_replace(',','',$entry['value']));
                        $data['normal_balance'] = $normalBalance;
                        $data['posted'] = 0;
                        $data['status'] = 1;
                        $entries[] = $data;
                    }
                }
                (new JournalEntries)->addEntries($entries);
                $this->updateTransactionCode($billing->transaction_no,$status);
                DB::table('tbl_billing')->where($this->conditions)->update(['status' => $status]);
                return $entries;
            }
        }
        return $billing;
    }

    private function generateSubsidiaryLedgers ($subAccount) : ?array {
        $keys = ['sl_code', 'type', 'desc'];
        $subLedger = array();
        foreach($subAccount as $key => $value){
            if(in_array($key,$keys)){
                $sub['key'] = $key;
                $sub['value'] = $value;
                $subLedger[] = $sub;
            }
        }
        return $subLedger;
    }

    private function checkBillingCode($code) : bool{
        $billingCode = DB::table('tbl_billing')->where('billing_no',$code)->first();
        return (bool)$billingCode;
    }
}
