<?php

namespace Accounting\transactions;
use Accounting\entries\JournalEntries;
use Accounting\ParamSetup;
use Base\DBQueries;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Transactions extends ParamSetup
{
    private string $tbl = 'tbl_transactions';
    private Request $request;

    private string $voucherCode;

    private string $transactionCode;
    private array $entries;

    private string $status;

    private string $transType;

    public function setParams(): array { return ['request' => $this->request, 'table' => $this->tbl]; }

    public function main (Request $request) : JsonResponse {
        $this->request = $request;
        if($request->type === 'code') {
            $request = $this->request;
            $condition = $request->conditions;
            $this->transType = $condition['type'];
            $this->generateVoucherCode();
            return successResponse("msg",$this->voucherCode);
        }
        try {
            if($this->generateParams()){
                $this->filterTable = $this->table;
                $action = $this->action;
                $this->status = $this->getValue('status') ?? '';
                $values = $this->values;
                if($values['type'] === 'RV'){
                    $details = $values['details'];
                    $this->transactionCode = $values['code'];
                    foreach($details as $key => $detail){
                        if($detail['normal_balance'] === 'Cr'){
                            $billing = DB::table('tbl_billing_list')->select('customer_code')->where('billing_no',$values['series'])->first();
                            if($billing){
                                $entry = DB::table('tbl_account_mapping')->select('account_code')->where('map_code',$billing->customer_code)
                                    ->where('category','receivable')->first();
                                if($entry) $details[$key]['account'] = $entry->account_code;
                            }
                        }
                    }
                    $this->entries = $details;
                    //return successResponse("", $this->entries);
                    $this->removeValueArray('details');
                    $this->execQuery();
                    $this->createReceiptVoucherEntries();
                    $this->updateBillingTransaction($values['series']);
                    return successResponse("", $this->response);
                }
                else if($this->status === 'added'){
                    $this->transType = 'RV';
                    $this->generateVoucherCode();
                    $dueDate = Carbon::parse($values['billing_date'])->addDays($values['terms'])->format('Y-m-d');
                    $this->addValues('due_date', $dueDate);
                    $this->addValues('outstanding', 0);
                    $this->addValues('payment', (float)$values['amount']);
                    $this->addValues('code', $this->voucherCode);
                    //return successResponse("", $this->values);
                    $this->removeValueArray('status');
                    $this->execQuery();
                    $this->createEntries();
                }
                $this->updateTransaction();
                return $this->getResponse($action);
            }
        }
        catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
    }

    private function getResponse($action) : ?JsonResponse{
        $this->filterResponse();
        $responseMsg = "No Data Found!";
        if($this->response) {
            if ($action === 'dbGet') {
                $response = $this->response;
                $this->responseParser($response);
                $details = (new DBQueries("tbl_billing_details", null, conditions: ["billing_number" => $response->billing_number]))->dbGetAll();
                $details->map(function ($details){
                    $details->amount = number_format($details->amount, 2, '.',',');
                });
                $response->details = $details;
                return successResponse("Success",$response);
            }
            else if ($action === 'dbGetAll') {
                $response = $this->response;
                foreach($response as $res){
                    $this->responseParser($res);
                }

                return successResponse("Success",$response);
            }
            else $responseMsg = "Success";
        }
        return successResponse($responseMsg, $this->response);
    }

    private function responseParser($response) {
        $response->dueDate = Carbon::parse($response->due_date)->format('d-M-Y');
        $response->billingDate = Carbon::parse($response->billing_date)->format('d-M-Y');
        $response->billingDateDetails = Carbon::parse($response->billing_date)->format('j F Y');
        $response->dueDateDetails = Carbon::parse($response->due_date)->format('j F Y');
        $response->termsDetails = $response->terms.' '.$response->unit;
        $response->amount = number_format($response->amount, 2, '.',',');
        $response->payment = number_format($response->payment, 2, '.',',');
        $response->outstanding = number_format($response->outstanding, 2, '.',',');
        return $response;
    }

    private function generateVoucherCode() : void {
        $code = date('Ym').'00001';
        $dbCode = DB::table('tbl_transactions')->orderByDesc('code')->first();
        if($dbCode){
            $code = $dbCode->code;
            $curMonth = date('Ym');
            $month = substr($code,2, 6);
            $incr = substr($code,8);
            if($curMonth === $month){
                $incr = (int)$incr + 1;
                if($incr < 10) $code = $curMonth.'0000'.$incr;
                else if($incr < 100) $code = $curMonth.'000'.$incr;
                else if($incr < 1000) $code = $curMonth.'00'.$incr;
                else if($incr < 10000) $code = $curMonth.'0'.$incr;
                else $code = $curMonth.$incr;
            }
            else $code = $curMonth.'00001';
        }

        $this->voucherCode = $this->transType.$code;
    }

    private function createEntries() : void {
        $values = $this->values;
        $entryMaster = DB::table('tbl_account_mapping')->select('account_code','map_code','normal_balance')->where('type','billing')
            ->where('category','transactions')->get();

        $entries = array();
        foreach($entryMaster as $entryDetails){
            $entry['acc_code'] = $entryDetails->account_code;
            $entry['trans_code'] = $values['code'];
            $entry['original_cur'] = 'PHP';
            $entry['local_cur'] = 'PHP';
            $entry['oc_value'] = 1;
            $entry['forex_rate'] = 1;
            $entry['lc_value'] = 1;
            $entry['actual_value'] = $values['amount'];
            $entry['normal_balance'] = $entryDetails->normal_balance;
            $entry['posted'] = 0;
            $entry['status'] = 1;
            $entries[] = $entry;
        }
        $this->entries = $entries;
        (new JournalEntries)->addEntries($entries);
    }

    private function createReceiptVoucherEntries() : void {
        $entryMaster = $this->entries;
        $entries = array();
        foreach($entryMaster as $details){
            $entry['acc_code'] = $details['account'];
            $entry['trans_code'] = $this->transactionCode;
            $entry['original_cur'] = 'PHP';
            $entry['local_cur'] = 'PHP';
            $entry['oc_value'] = 1;
            $entry['forex_rate'] = 1;
            $entry['lc_value'] = 1;
            $entry['actual_value'] = str_replace(",","",$details['amount']);
            $entry['normal_balance'] = $details['normal_balance'];
            $entry['posted'] = 0;
            $entry['status'] = 1;
            $entries[] = $entry;
        }
        $this->entries = $entries;
        (new JournalEntries)->addEntries($entries);
    }

    private function updateTransaction() : void {
        $values = $this->values;
        if($values['type'] === 'billing'){
            DB::table('tbl_billing_list')->where('billing_number',$values['series'])
                ->update(['status' => $this->status]);
        }
    }

    private function updateBillingTransaction($code) : void {
        $billing = DB::table('tbl_billing_list')->select()->where('billing_no',$code)->first();
        if($billing){
            DB::table('tbl_billing_list')->where('billing_no',$code)->update([
                'payment' => (float)$billing->amount,
                'outstanding' => 0.00,
                'status' => 'full'
            ]);
        }
    }

}
