<?php

namespace Accounting\setup;

use Base\DBQueries;

class AccountMapping
{
    public function saveAccountMapRecord($accountCode, $customerSupplierCode, $normalBalance, $accountMapType, $accountMapCategory)
    {
        $values["type"] = $accountMapType;
        $values["category"] = $accountMapCategory;
        $values["normal_balance"] = $normalBalance;
        $values["map_code"] = $customerSupplierCode;
        $values["account_code"] = $accountCode;

        return (new DBQueries("tbl_account_mapping", $values))->dbInsert();
    }

    public function updateAccountMapRecord($accountCode, $customerSupplierCode, $normalBalance, $accountMapType, $accountMapCategory){
        $values["type"] = $accountMapType;
        $values["category"] = $accountMapCategory;
        $values["normal_balance"] = $normalBalance;
        $conditions["map_code"] = $customerSupplierCode;
        $values["account_code"] = $accountCode;

        return (new DBQueries("tbl_account_mapping", $values, $conditions))->dbUpdate();
    }

    public function getAccountMapRecord($customerSupplierCode)
    {
        return (new DBQueries("tbl_account_mapping", conditions: ["map_code" => $customerSupplierCode]))->dbGet();
    }
}
