<?php

namespace Accounting\reports;

use Accounting\ParamSetup;
use Base\DBQueries;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GeneralLedgers extends ParamSetup
{

    private string $tbl = 'tbl_general_ledgers';
    private Request $request;
    private ?array $details;
    private ?string $accountCode;

    public function setParams(): array { return ['request' => $this->request, 'table' => $this->tbl];}

    public function main(Request $request){
        $param = $request->all();
        $this->request = $request;
        try {
            if($this->generateParams()){
                if($this->action === 'dbGetAll'){
                    $conditions = $this->conditions;
                    $dates = explode(':', $conditions['dates']);
                    $this->response = DB::table($this->tbl)->where('acc_code',$conditions['acc_code'])
                        ->where('transaction_date','>=',$dates[0])
                        ->where('transaction_date','<=',$dates[1])->orderBy('created_at')->get();
                    return $this->parseResponse();
                    return successResponse("Success",$dates);
                    $action = $this->action;
                    $this->execQuery();
                    return $this->parseResponse();
                }

            }
        }
        catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
    }

    private function parseResponse() : ?JsonResponse {
        $response = $this->response;
        $response = $response->map(function ($response){
            $entity = null;
            $entities = null;
            $subLedger = DB::table('tbl_subsidiary_ledgers')->where('gl_id', $response->id)->first();
            if($subLedger){
                $entities = DB::table('tbl_entities')->where('code', $subLedger->sl_code)->first();
                $entity = $entities?->name;
                if($entities === null){
                    $entities = DB::table('tbl_operations')->where('code', $subLedger->sl_code)->first();
                    $entity = $entities?->name;
                }
            }
            $amount = number_format($response->amount,2,'.',',');
            $response->debit = $response->debit_credit === 'Dr' ? $amount : null;
            $response->credit = $response->debit_credit === 'Cr' ? $amount : null;
            $response->postStatus = $response->status;
            $return['data'] = $response;
            $return['debit'] = $response->debit_credit === 'Dr' ? $amount : null;
            $return['credit'] = $response->debit_credit === 'Cr' ? $amount : null;
            $return['transDate'] = $response->transaction_date ? Carbon::parse($response->transaction_date)->format('d-M-Y') : date('d-M-Y');
            $return['postedDate'] = Carbon::parse($response->created_at)->format('d-M-Y');
            $return['status'] = $response->status;
            $return['code'] = $response->code;
            $return['balance'] = formatAccountingCurrency($response->ending_balance);
            $journal = DB::table('tbl_journal')->where('code', $response->journal_code)->first();
            $particulars = $entity ?? null;
            $particulars = $particulars.($journal ? $journal->particulars ? ($particulars ? ' | '.$journal->particulars : $journal->particulars) : null : null); // Journal Particulars
            $particulars = $particulars.($response ? $response->description ? ($particulars ? ' | '.$response->description : $response->description) : null : null); // General Ledger Particulars
            //$particulars = $particulars.($subLedger ? $subLedger->particulars ? ($particulars ? ' | '.$subLedger->particulars : $subLedger->particulars) : null : null); // Subsidiary Ledger Particulars
            $return['particulars'] = $particulars;
            $return['sl'] = $subLedger;
            return $return;
        });
        return successResponse("Success",$response);
    }
}
