<?php

use Illuminate\Validation\Rule;

class UniqueEntityDetailValueValidation {

    private string $column;
    private string $entityCode;
    private string $value;

    public function __construct(array $params) {
        $this->column = data_get($params, "column");
        $this->entityCode = data_get($params, "entityCode");
        $this->value = data_get($params, "value");
    }

    public function parseRule() {
        return Rule::unique("tbl_entity_details")->where([
            "type" => $this->column,
        ]);
    }
}
