<?php

namespace Accounting\config;

use Accounting\ParamSetup;
use Base\DBQueries;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TestOperationsController extends ParamSetup
{
    private string $tbl = 'tbl_operations';
    private Request $request;
    private $operation_code;
    //private $parent_code;
    private $current_code;

    private $operation_status;
    private array $others;
    private $parents = array();
    private $children = array();
    private $operationsToMap = array();
    private $operationsToNotInclude = array();
    const ARRAY_CATEGORIES = ['branches', 'departments'];
    public function setParams()
    {
        return ['request' => $this->request, 'table' => $this->tbl];
    }

    public function main(Request $request): JsonResponse
    {
        $this->request = $request;

        try {
            if($this->generateParams()){
                $this->filterTable = $this->table;
                $action = $this->action;
                if (in_array($this->filterTable, array_keys(HIDDEN_REQUEST_FIELDS))) $this->others = $this->filterRequest();
                $this->execQuery();
                //$this->parent_code = $this->getValue('code');
                $this->current_code = $this->getValue('code');
                if ($this->response || $this->request->input("type") === "update") $this->saveOtherDetails();
                if ($this->response && $this->request->input("type") === "delete") $this->deleteDetails();

                if($action === 'dbInsert') $this->saveToOperationsRelationshipTable();
//                if($action !== 'dbGetAll') $this->saveRelationship();
//                if (!empty($this->operationsToMap)) {
//                    $this->saveOperationRelationship();
//                }
//                if($action !== 'dbGetAll') {
//                    $this->updateOperationRelationship();
//                    $this->updateOptRelationshipNode();
//                }
                return $this->getResponse($action);
            }
        } catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
    }
    private function getResponse($action): ?JsonResponse
    {
        if (in_array($this->filterTable, array_keys(HIDDEN_RESPONSE_FIELDS))) $this->filterResponse();
        $responseMsg = "No Data Found!";
        if($this->response) {
            if($action == 'dbInsert') {
                $responseMsg = 'op_code';
            } else if($action === 'dbGetAll') {
                $response = $this->response;
                foreach ($response as $key => $data) {
                    $data->details = (new DBQueries("tbl_operations_details", null, conditions: ["op_code" => $data->code]))->dbGetAll();
                    $this->responseParser($data);
                }
                return successResponse("Success", $response);
            } else $responseMsg = "Success";
        }

        if($action === 'dbDelete') {
            $responseMsg = 'Successfully deleted!';
            $value = $this->conditions;
            $code = $value['code'];
            $query = DB::table('tbl_operations_relationship')->where('op_code', $code);
            foreach ($query->get() as $row) {
                if(!$this->isOperationParent($row->parent_code)) $this->setParentNode($row->parent_code, 1);
            }
        }
        return successResponse($responseMsg, $this->response);
    }

    public function saveOtherDetails()
    {
        $this->operation_code = $this->getValue('code');
        $this->operation_status = $this->getValue('status');
        if ($this->action === 'dbInsert') {
            $details = $this->others;
            foreach ($details['details'] as $k => $detail) {
                if (is_array($detail) || is_object($detail)) {
                    foreach ($detail as $key => $value) {
                        if (is_array($value)) {
                            foreach ($value as $k2 => $val) {
                                array_push($this->operationsToMap, $val);
                                $this->addOtherDetails($k2, $k, $val);
                            }
                        } else $this->addOtherDetails($key, $k, $value);
                    }
                } else $this->addOtherDetails($k, 'info', $detail);
            }
        } else if ($this->action === "dbUpdate") {
            DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
                ->update(['status' => $this->operation_status]);
            $details = $this->others;
            foreach($details['details'] as $k => $detail) {
                if (is_array($detail)) {
                    foreach($detail as $key => $value) {
                        if (is_array($value)) {
                            foreach ($value as $k2 => $val) {
                                array_push($this->operationsToMap, $val);
                                $this->updateOtherDetails($k2, $k, $val);
                            }
                        }else $this->updateOtherDetails($key, $k, $value);
                    }
                } else $this->updateOtherDetails($k, "info", $detail);
            }
            // for types that doesn't have array values ex. department
            // $this->onUpdateRemoveFields();
        }
    }

    private function addOtherDetails($type, $category, $value): void
    {
        $this->operation_code = $this->getValue('code');
        $values['op_code'] = $this->operation_code;
        $values['type'] = $type;
        $values['category'] = $category;
        $values['value'] = $value;
        $values['status'] = $this->operation_status;
        $add = new DBQueries('tbl_operations_details', $values);
        $this->response = $add->dbInsert();

    }
    private function updateOtherDetails($type, $category, $value): void
    {
        $this->operation_code = $this->getValue('code');
        $conditions["op_code"] = $this->operation_code;
        $conditions["type"] = $type;
        $conditions["category"] = $category;
        $values["value"] = $value;
        $values["status"] = $this->operation_status;
        $query = DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
            ->where('type', $type)->where('value', $value)->first();

        if(empty($query) && in_array($category, self::ARRAY_CATEGORIES)){
            $this->addOtherDetails($type, $category, $value);
            return ;
        }
        if(!empty($query) && in_array($category, self::ARRAY_CATEGORIES) && !is_null($query->deleted_at)) {
            DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
                ->where('type', $type)->where('value', $value)->update(['deleted_at' => null]);
            return ;
        }

        if(!in_array($category, self::ARRAY_CATEGORIES)){
            $this->response =  (new DBQueries("tbl_operations_details", $values, $conditions))->dbUpdate();
        }
    }

    private function deleteDetails() : void {
        $operation_code = $this->conditions['code'];
        $conditions["op_code"] = $operation_code;
        $this->response =  (new DBQueries("tbl_operations_details", null, $conditions))->dbDelete();

        $this->deleteGroupOptRelationship($operation_code);
    }

    private function saveToOperationsRelationshipTable() : void {
        $code = $this->getValue('code');
        $type = $this->getValue('type');
        $name = $this->getValue('name');
        $status = $this->getValue('status');

        $values["code"] = $code;
        $values["op_code"] = $code;
        $values["parent_code"] = 0;
        $values["desc"] = $name;
        $values["type"] = $type;
        $values["status"] = $status;
        $values["node"] = 1;

        $this->response = (new DBQueries("tbl_operations_relationship", $values))->dbInsert();
    }

    private function getOperationsRelationship() {
        if (in_array('tbl_operations_relationship', array_keys(HIDDEN_RESPONSE_FIELDS))) $this->filterResponse();
        return (new DBQueries("tbl_operations_relationship"))->dbGetAll();
    }

    private function responseParser($response) : void {
        $branchCodes = array();
        $departmentCodes = array();
        foreach($response->details as $detail) {
            $key = $detail->category;
            if($key === 'branches') {
                array_push($branchCodes, array('branchCode' => $detail->value));
            }
            if($key === 'departments') {
                array_push($departmentCodes, array('departmentCode' => $detail->value));
            }
            $response->$key[$detail->type] = $detail->value ?? "";
        }
        if(!empty($branchCodes)) $response->branches = $branchCodes;
        if(!empty($departmentCodes)) $response->departments = $departmentCodes;
        unset($response->details);
    }

    private function onUpdateRemoveFields() : void {
        $type = $this->getValue('type');

        $mapping = [
            "operation" => [
                "category" => "branches",
            ],
            "branch" => [
                "category" => "departments"
            ]
        ];

        $query = DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
            ->where('category', $mapping[$type]["category"]);

        if($this->valuesToUpdate) {
            $dataToRetain = $this->valuesToUpdate;
            foreach($query->get() as $row) {
                if(!in_array($row->value, $dataToRetain)){
                    DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
                        ->where('category', $mapping[$type]["category"])->where('value', $row->value)->delete();

                    // FOR SOFT DELETE
                    /* $conditions["op_code"] = $this->operation_code;
                    $conditions["category"] = '$mapping[$type]["category"]';
                    $conditions["value"] = $row->value;
                    $this->response =  (new DBQueries("tbl_operations_details", null, $conditions))->dbDelete(); */
                }
            }
        } else {
            DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
                ->where('category', $mapping[$type]["category"])->delete();
        }
    }

    /** Generates the code for the operations relationship **/
    private function optRelationshipCodeGenerator($operationCode): string {
        $parent_code = $this->getValue('code');
        $parent_of_parent_code = DB::table('tbl_operations_relationship')->select('parent_code')->where('op_code', $parent_code)->first();
        if($parent_of_parent_code) return $parent_of_parent_code->parent_code . $parent_code . $operationCode;
        return $parent_code . $operationCode;
    }

    private function saveRelationship () : void
    {
        $type = $this->getValue('type');
        $status = $this->getValue('status');

        if($type === 'operation') $operation_type = 'BR';
        else if($type === 'branch') $operation_type = 'DP';

        if(!empty($this->operationsToMap)) $operations = $this->operationsToMap;
        if($this->hasParent($this->current_code)) {
            $setParentPlaceholder = array();
            foreach ($this->parents as $parent) {
                $query = DB::table('tbl_operations_relationship')->select('code')->where('parent_code', $parent)->get();
                foreach ($query as $data) array_push($setParentPlaceholder, $data->code);
            }
            $this->parents = $setParentPlaceholder;
            if(!empty($operations)) {

                if(!empty($this->parents)) {
                    $parents = $this->parents;
                    foreach ($parents as $parent) {
                        DB::table('tbl_operations_relationship')->where('code', $parent)->update(['node' => 0]);
                        foreach ($operations as $operation) {
                            $code = $parent . $operation;
                            if(!$this->isDuplicated($code)) $this->insertOperationRelationShip($code, $operation, $parent, $operation_type, $status);
                        }
                    }
                } else {
                    foreach ($operations as $operation) {
                        $code = $this->current_code . $operation;
                        $parent = $this->current_code;
                        if(!$this->isDuplicated($code)) $this->insertOperationRelationShip($code, $operation, $parent, $operation_type, $status);
                    }
                }
            }
        } else {
            if(!empty($operations)) {
                foreach ($operations as $operation) {
                    if($this->hasChildren($operation)) {
                        $children = $this->children;
                        foreach ($children as $child) {
                            $operation_type = 'DP';
                            $code = $this->current_code . $operation . $child;
                            $parent = $this->current_code . $operation;
                            if(!$this->isDuplicated($code)) $this->insertOperationRelationShip($code, $child, $parent, $operation_type, $status);
                        }
                    }
                    $operation_type = 'BR';
                    $code = $this->current_code . $operation;
                    $parent = $this->current_code;
                    if(!$this->isDuplicated($code)) $this->insertOperationRelationShip($code, $operation, $parent, $operation_type, $status);
                }
            }
        }
    }

    private function isDuplicated ($code) : bool
    {
        $query = DB::table('tbl_operations_relationship')->where('code', $code)->get();
        if($query->isEmpty()) return false;
        return true;
    }

    private function saveOperationRelationship() : void {
        $operations = $this->operationsToMap;
        $type = $this->getValue('type');
        $status = $this->getValue('status');

        if($type === 'operation') $operation_type = 'BR';
        else if($type === 'branch') $operation_type = 'DP';

        foreach ($operations as $k => $value) {
            // checks if the operation has parent
            $code = $this->optRelationshipCodeGenerator($value);
            $query = DB::table('tbl_operations_relationship')->where('code', $code)->first();
            if(empty($query)) $this->insertOperationRelationShip($code, $value, $operation_type, $status);
            if(!empty($query) && !is_null($query->deleted_at)) {
                DB::table('tbl_operations_relationship')->where('code', $code)->update(['deleted_at' => null]);
            }

            DB::table('tbl_operations_relationship')->where('code', $code)->update(["status" => $status]);
        }
    }

    private function hasParent($current_operation) : bool {
        $doesHaveParent = DB::table('tbl_operations_relationship')->select('parent_code')->where('op_code', $current_operation)->get();
        if($doesHaveParent->isNotEmpty()) {
            foreach ($doesHaveParent as $parents) {
                array_push($this->parents, $parents->parent_code);
            }
            return true;
        }
        return false;
    }

    private function hasChildren($current_operation) : bool {
        $doesHaveChildren = DB::table('tbl_operations_relationship')->select('op_code')->where('parent_code', $current_operation)->get();
        if($doesHaveChildren->isNotEmpty()) {
            foreach ($doesHaveChildren as $child) {
                array_push($this->children, $child->op_code);
            }
            return true;
        }
        return false;
    }

    private function insertOperationRelationShip($code, $operation_code, $parent, $opt_type, $status) : void {
        $values["code"] = $code;
        $values["op_code"] = $operation_code;
        $values["parent_code"] = $parent;
        $values["type"] = $opt_type;
        $values["status"] = $status;
        $values["node"] = 1;

        $this->response = (new DBQueries("tbl_operations_relationship", $values))->dbInsert();
    }

    private function updateOptRelationshipNode(): void {
        if(!empty($this->operationsToMap)) {
            $operations = $this->operationsToMap;
            foreach ($operations as $k => $value) {
                if($this->isOperationParent($value)) {
                    $this->setParentNode($value, 0);
                }
            }

            $this->setParentNode($this->parent_code, 0);
        }
    }
    private function isOperationParent($op_code): bool {
        $isParent = DB::table('tbl_operations_relationship')->where('parent_code', $op_code)->whereNull('deleted_at')->get();
        if(!$isParent->isEmpty()) {
            return true;
        }
        return false;
    }

    private function setParentNode($code, $node):void {
        DB::table('tbl_operations_relationship')->where('op_code', $code)->update(['node' => $node]);
    }

    /** Deletes or undelete operation relationship based on operations and branches input **/
    private function updateOperationRelationship() : void {
        $parentRelations = DB::table('tbl_operations_relationship')->where('parent_code', $this->parent_code)->get();
        if(!empty($this->operationsToMap)) {
            $retainedOperations = $this->operationsToMap;
            foreach($parentRelations as $row) {
                if(!in_array($row->op_code, $retainedOperations)) {
                    $code = $this->optRelationshipCodeGenerator($row->op_code);
                    $this->softDeleteOptRelationship($code, $row->op_code);
                    if(!$this->isOperationParent($row->op_code)) {
                        $this->setParentNode($row->op_code, 1);
                    }
                }
            }
        } else {
            $conditions['parent_code'] = $this->parent_code;
            $this->response = (new DBQueries("tbl_operations_relationship", null, $conditions))->dbDelete();
            $this->setParentNode($this->parent_code, 1);
        }
    }

    private function softDeleteOptRelationship($code, $op_code) : void {
        $conditions["code"] = $code;
        $conditions["op_code"] = $op_code;
        $this->response =  (new DBQueries("tbl_operations_relationship", null, $conditions))->dbDelete();
    }

    private function deleteGroupOptRelationship($parent_code) : void {
        $conditions["parent_code"] = $parent_code;
        $second_conditions["op_code"] = $parent_code;
        (new DBQueries("tbl_operations_relationship", null, $conditions))->dbDelete();
        (new DBQueries("tbl_operations_relationship", null, $second_conditions))->dbDelete();
    }
}
