<?php

namespace Accounting\config;

use Accounting\ParamSetup;
use Base\DBQueries;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class SystemUsers extends ParamSetup {
    private string $tbl = 'system_users';
    private Request $request;
    public function setParams(): array { return ['request' => $this->request, 'table' => $this->tbl];}

    public function main(Request $request) : JsonResponse {
        $this->request = $request;
        try {
            if($this->generateParams()){
                $this->filterTable = $this->table;
                $action = $this->action;
                $this->addValues('status', 1);
                $query =  New DBQueries($this->table, $this->values, $this->conditions, $this->sort, $this->limit, $this->key);
                $this->response = $query->$action();
                return $this->getResponse($action);
            }
        } catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
    }

    private function getResponse($action): ?JsonResponse {
        if (in_array('system_users', array_keys(HIDDEN_RESPONSE_FIELDS))) $this->filterResponse();
        $responseMsg = "No Data Found!";
        if ($this->response) {
            if ($action === 'dbInsert') {
                $responseMsg = "user_name";
            } else if ($action === 'dbGet') {
                $response = $this->response;
                $res = new DBQueries("system_users", null, ["user_name" => $response->user_name]);
                $response = $res->dbGetAll();
                return successResponse("Success", $response);
            } else if ($action === 'dbGetAll') {
                $response = $this->response;
                return successResponse("Success", $response);
            } else $responseMsg = "Success";
        }
        return successResponse($responseMsg, $this->response);
    }

}
