<?php

namespace Accounting\config;

use Accounting\ParamSetup;
use Base\DBQueries;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OperationsController extends ParamSetup
{
    private string $tbl = 'tbl_operations';
    private Request $request;
    private $operation_code;
    private $parent_code;
    private $operation_status;
    private array $others;
    private $valuesToUpdate = array();
    private $operationsToMap = array();
    const ARRAY_CATEGORIES = ['branches', 'departments'];
    public function setParams()
    {
        return ['request' => $this->request, 'table' => $this->tbl];
    }

    public function main(Request $request): JsonResponse
    {
        $this->request = $request;

        try {
            if($this->generateParams()){
                $this->filterTable = $this->table;
                $action = $this->action;
                if (in_array($this->filterTable, array_keys(HIDDEN_REQUEST_FIELDS))) $this->others = $this->filterRequest();
                $this->parent_code = $this->getValue('code');
                $this->values['code'] = strtoupper($this->parent_code);
                $this->execQuery();
                if ($this->response || $this->request->input("type") === "update") if($this->getValue('type') !== 'admin') $this->saveOtherDetails();
                if ($this->response && $this->request->input("type") === "delete") if($this->getValue('type') !== 'admin') $this->deleteDetails();
                if($action === 'dbInsert') if($this->getValue('type') !== 'admin') $this->saveToOperationsRelationshipTable();

                return $this->getResponse($action);
            }
        } catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
    }
    private function getResponse($action): ?JsonResponse
    {
        if (in_array($this->filterTable, array_keys(HIDDEN_RESPONSE_FIELDS))) $this->filterResponse();
        $responseMsg = "No Data Found!";
        if($this->response) {
            if($action == 'dbInsert') {
                $responseMsg = 'op_code';
            } else if($action === 'dbGetAll') {
                $response = $this->response;
                foreach ($response as $key => $data) {
                    $data->details = (new DBQueries("tbl_operations_details", null, conditions: ["op_code" => $data->code]))->dbGetAll();
                    $this->responseParser($data);
                }
                return successResponse("Success", $response);
            } else $responseMsg = "Success";
        }
        return successResponse($responseMsg, $this->response);
    }

    public function saveOtherDetails()
    {
        $this->operation_code = $this->getValue('code');
        $this->operation_status = $this->getValue('status');
        if ($this->action === 'dbInsert') {
            $details = $this->others;
            foreach ($details['details'] as $k => $detail) {
                if (is_array($detail) || is_object($detail)) {
                    foreach ($detail as $key => $value) {
                        if (is_array($value)) {
                            foreach ($value as $k2 => $val) {
                                array_push($this->operationsToMap, $val);
                                $this->addOtherDetails($k2, $k, $val);
                            }
                        } else $this->addOtherDetails($key, $k, $value);
                    }
                } else $this->addOtherDetails($k, 'info', $detail);
            }
        } else if ($this->action === "dbUpdate") {
            DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
                ->update(['status' => $this->operation_status]);
            $details = $this->others;
            foreach($details['details'] as $k => $detail) {
                if (is_array($detail)) {
                    foreach($detail as $key => $value) {
                        if (is_array($value)) {
                            foreach ($value as $k2 => $val) {
                                array_push($this->valuesToUpdate, $val);
                                array_push($this->operationsToMap, $val);
                                $this->updateOtherDetails($k2, $k, $val);
                            }
                        }else $this->updateOtherDetails($key, $k, $value);
                    }
                } else $this->updateOtherDetails($k, "info", $detail);
            }
        }
    }

    private function addOtherDetails($type, $category, $value): void
    {
        $this->operation_code = $this->getValue('code');
        $values['op_code'] = $this->operation_code;
        $values['type'] = $type;
        $values['category'] = $category;
        $values['value'] = $value;
        $values['status'] = $this->operation_status;
        $add = new DBQueries('tbl_operations_details', $values);
        $this->response = $add->dbInsert();

    }
    private function updateOtherDetails($type, $category, $value): void
    {
        $this->operation_code = $this->getValue('code');
        $conditions["op_code"] = $this->operation_code;
        $conditions["type"] = $type;
        $conditions["category"] = $category;
        $values["value"] = $value;
        $values["status"] = $this->operation_status;
        $query = DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
            ->where('type', $type)->where('value', $value)->first();

        if(empty($query) && in_array($category, self::ARRAY_CATEGORIES)){
            $this->addOtherDetails($type, $category, $value);
            return ;
        }
        if(!empty($query) && in_array($category, self::ARRAY_CATEGORIES) && !is_null($query->deleted_at)) {
            DB::table('tbl_operations_details')->where('op_code', $this->operation_code)
                ->where('type', $type)->where('value', $value)->update(['deleted_at' => null]);
            return ;
        }

        if(!in_array($category, self::ARRAY_CATEGORIES)){
            $this->response =  (new DBQueries("tbl_operations_details", $values, $conditions))->dbUpdate();
        }
    }

    private function deleteDetails() : void {
        $operation_code = $this->conditions['code'];
        $conditions["op_code"] = $operation_code;
        $this->response =  (new DBQueries("tbl_operations_details", null, $conditions))->dbDelete();

        $this->deleteGroupOptRelationship($operation_code);
    }

    private function responseParser($response) : void {
        $branchCodes = array();
        $departmentCodes = array();
        foreach($response->details as $detail) {
            $key = $detail->category;
            if($key === 'branches') {
                array_push($branchCodes, array('branchCode' => $detail->value));
            }
            if($key === 'departments') {
                array_push($departmentCodes, array('departmentCode' => $detail->value));
            }
            $response->$key[$detail->type] = $detail->value ?? "";
        }
        if(!empty($branchCodes)) $response->branches = $branchCodes;
        if(!empty($departmentCodes)) $response->departments = $departmentCodes;
        unset($response->details);
    }

    private function saveToOperationsRelationshipTable() : void {
        $code = $this->getValue('code');
        $type = $this->getValue('type');
        $name = $this->getValue('name');
        $status = $this->getValue('status');

        $values["code"] = $code;
        $values["op_code"] = $code;
        $values["parent_code"] = 0;
        $values["desc"] = $name;
        $values["type"] = $type;
        $values["status"] = $status;
        $values["node"] = 0;

        $this->response = (new DBQueries("tbl_operations_relationship", $values))->dbInsert();
    }

    /** Generates the code for the operations relationship (PARENTCODE + OPCODE) **/
    private function optRelationshipCodeGenerator($operationCode): string {
        $parent_code = $this->getValue('code');
        $parent_of_parent_code = DB::table('tbl_operations_relationship')->select('parent_code')->where('op_code', $parent_code)->first();
        if($parent_of_parent_code) return $parent_of_parent_code->parent_code . $parent_code . $operationCode;
        return $parent_code . $operationCode;
    }

    private function isOperationParent($op_code): bool {
        $isParent = DB::table('tbl_operations_relationship')->where('parent_code', $op_code)->whereNull('deleted_at')->get();
        if(!$isParent->isEmpty()) {
            return true;
        }
        return false;
    }
}
