<?php

namespace Accounting\config;

use Accounting\ParamSetup;
use Base\DBQueries;
use Base\Tables\RequestServices;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CRUDSetup extends ParamSetup
{
    private string $tbl;
    private Request $request;

    public function setParams(): array {
        $this->tbl = RequestServices::distinct()->select("table")->where("request", $this->request->input("request"))->first()->table;
        return ['request' => $this->request, 'table' => $this->tbl];
    }

    public function main(Request $request): ?JsonResponse {
        $this->request = $request;
        try {
            if ($this->generateParams()) {
                $action = $this->action;
                $code = $this->getValue('code');
                if((!is_null($code) || strlen($code)!== 0) && $action === 'dbInsert' && !$this->checkDuplicates($this->tbl, 'code', $code)) {
                    return failedResponse("ERROR", ["msg" => 'Duplicate code.'], 422);
                }
                $query =  New DBQueries($this->table, $this->values, $this->conditions, $this->sort, $this->limit, $this->key);
                $this->response = $query->$action();
                return $this->getResponse();
            }
        } catch (\Exception $ex) {
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
//        return null;
    }

    public function getResponse() : ?JsonResponse{
        $this->filterTable = $this->tbl;
        if (in_array($this->filterTable, array_keys(HIDDEN_RESPONSE_FIELDS)))  $this->filterResponse();
        if($this->response) return successResponse("Success", $this->response);
        else return successResponse("No Data Found!", $this->response);
    }
}
