<?php

namespace Accounting\billing;

use Accounting\ParamSetup;
use Base\DBQueries;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OperationTransactions extends ParamSetup
{
    private string $tbl = 'tbl_operation_trans';
    private Request $request;

    public function setParams(): array { return ['request' => $this->request, 'table' => $this->tbl]; }

    public function main (Request $request) : JsonResponse {
        $this->request = $request;
        try {
            if($this->generateParams()){
                $this->filterTable = $this->table;
                $action = $this->action;
                $this->execQuery();
                //return successResponse("Success",$this->response);
                return $this->getResponse($action);
            }
        }
        catch (\Exception $ex){
            return failedResponse("ERROR", ["msg" => $ex->getMessage()], 422);
        }
        return failedResponse("ERROR", ["msg" => "Unknown Error!"], 400);
    }

    private function getResponse($action) : ?JsonResponse{
        $this->filterResponse();
        $responseMsg = "No Data Found!";
        if($this->response) {
            if ($action === 'dbGet') {
                $response = $this->response;
                $this->responseParser($response);
                $details = (new DBQueries("tbl_operation_trans_details", null, conditions: ["trans_no" => $response->trans_no]))->dbGetAll();
                $details->map(function ($details){
                    $details->amount = number_format($details->amount, 2, '.',',');
                });
                $response->details = $details;
                $response->client = (new DBQueries("tbl_entities", null, conditions: ["code" => $response->customer_code]))->dbGet();

                return successResponse("Success",$response);
            }
            else if ($action === 'dbGetAll') {
                $response = $this->response;
                foreach($response as $res){
                    $this->responseParser($res);
                }

                return successResponse("Success",$response);
            }
            else $responseMsg = "Success";
        }
        return successResponse($responseMsg, $this->response);
    }

    private function responseParser($response) {
        $response->dueDate = Carbon::parse($response->due_date)->format('d-M-Y');
        $response->transDate = Carbon::parse($response->trans_date)->format('d-M-Y');
        $response->termsDetails = $response->terms.' '.$response->unit;
        $response->amountDetails = number_format($response->amount, 2, '.',',');
        if($response->customer_code){
            $customer = DB::table('tbl_entities')->where('code',$response->customer_code)->first();
            if($customer){
                $response->customerName = $customer?->name;
            }
        }
        return $response;
    }
}
